; -------------------------------------------------------------------------------------------------------------- ;
; Beach Head - SPRITES.prg
; -------------------------------------------------------------------------------------------------------------- ;
; Memory Map
; -------------------------------------------------------------------------------------------------------------- ;
; $0000 - $00ff:  Zero Page Values
; $0200 - $02ff:  Work Values and C64 system
; $0300 - $03ff:  Work Values and C64 system
; -------------------------------------------------------------------------------------------------------------- ;
                        * equ $3f00
; -------------------------------------------------------------------------------------------------------------- ;
; compiler settings
; -------------------------------------------------------------------------------------------------------------- ;
                        incdir  ..\inc              ; C64 System Includes

C64Memory               include mem.asm             ; Memory Layout
; -------------------------------------------------------------------------------------------------------------- ;
TabSpriteDataOrig       = TabSpriteData             ; 
TabSpriteDataStore      = $e000                     ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_3f00                  dc.b $57 ; .#.#.###
                        dc.b $00 ; ........
                        dc.b $08 ; ....#...
                        dc.b $0d ; ....##.#
                        dc.b $b4 ; #.##.#..
                        dc.b $18 ; ...##...
                        dc.b $3b ; ..###.##
                        dc.b $8d ; #...##.#
                        dc.b $2e ; ..#.###.
                        dc.b $3b ; ..###.##
                        dc.b $a6 ; #.#..##.
                        dc.b $10 ; ...#....
                        dc.b $3b ; ..###.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $2e ; ..#.###.
A_3f10                  dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $22 ; ..#...#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ca ; ##..#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $08 ; ....#...
A_3f20                  dc.b $0a ; ....#.#.
                        dc.b $8e ; #...###.
                        dc.b $aa ; #.#.#.#.
                        dc.b $88 ; #...#...
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $a7 ; #.#..###
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $00 ; ........
                        dc.b $41 ; .#.....#
                        dc.b $08 ; ....#...
A_3f30                  dc.b $b0 ; #.##....
                        dc.b $18 ; ...##...
                        dc.b $3b ; ..###.##
                        dc.b $53 ; .#.#..##
                        dc.b $55 ; .#.#.#.#
                        dc.b $c2 ; ##....#.
                        dc.b $a0 ; #.#.....
                        dc.b $a4 ; #.#..#..
                        dc.b $23 ; ..#...##
                        dc.b $44 ; .#...#..
                        dc.b $4f ; .#..####
                        dc.b $20 ; ..#.....
                        dc.b $01 ; .......#
                        dc.b $2a ; ..#.#.#.
                        dc.b $4c ; .#..##..
                        dc.b $cc ; ##..##..
A_3f40                  dc.b $00 ; ........
                        dc.b $66 ; .##..##.
                        dc.b $3f ; ..######
                        dc.b $b8 ; #.###...
                        dc.b $18 ; ...##...
                        dc.b $3b ; ..###.##
                        dc.b $22 ; ..#...#.
                        dc.b $20 ; ..#.....
                        dc.b $45 ; .#...#.#
                        dc.b $ce ; ##..###.
                        dc.b $54 ; .#.#.#..
                        dc.b $45 ; .#...#.#
                        dc.b $52 ; .#.#..#.
                        dc.b $20 ; ..#.....
                        dc.b $57 ; .#.#.###
                        dc.b $49 ; .#..#..#
A_3f50                  dc.b $44 ; .#...#..
                        dc.b $48 ; .#..#...
                        dc.b $20 ; ..#.....
                        dc.b $58 ; .#.##...
                        dc.b $b2 ; #.##..#.
                        dc.b $52 ; .#.#..#.
                        dc.b $4f ; .#..####
                        dc.b $57 ; .#.#.###
                        dc.b $20 ; ..#.....
                        dc.b $42 ; .#....#.
                        dc.b $05 ; .....#.#
                        dc.b $49 ; .#..#..#
                        dc.b $4e ; .#..###.
                        dc.b $47 ; .#...###
                        dc.b $20 ; ..#.....
                        dc.b $46 ; .#...##.
A_3f60                  dc.b $49 ; .#..#..#
                        dc.b $4c ; .#..##..
                        dc.b $4c ; .#..##..
                        dc.b $45 ; .#...#.#
                        dc.b $44 ; .#...#..
                        dc.b $00 ; ........
                        dc.b $8e ; #...###.
                        dc.b $3f ; ..######
                        dc.b $c4 ; ##...#..
                        dc.b $18 ; ...##...
                        dc.b $3b ; ..###.##
                        dc.b $0b ; ....#.##
                        dc.b $20 ; ..#.....
                        dc.b $20 ; ..#.....
                        dc.b $20 ; ..#.....
                        dc.b $20 ; ..#.....
A_3f70                  dc.b $20 ; ..#.....
                        dc.b $20 ; ..#.....
                        dc.b $20 ; ..#.....
                        dc.b $20 ; ..#.....
                        dc.b $43 ; .#....##
                        dc.b $4f ; .#..####
                        dc.b $4c ; .#..##..
                        dc.b $4d ; .#..##.#
                        dc.b $4b ; .#..#.##
                        dc.b $32 ; ..##..#.
                        dc.b $42 ; .#....#.
                        dc.b $4b ; .#..#.##
                        dc.b $43 ; .#....##
                        dc.b $44 ; .#...#..
                        dc.b $20 ; ..#.....
                        dc.b $02 ; ......#.
; -------------------------------------------------------------------------------------------------------------- ;
SpriteDataCopy          ldy #$1e                    ; 
                        ldx #$00                    ; 
.GetSpriteDataCopy      lda TabSpriteDataOrig,x     ; 
.SetSpriteDataCopy      sta TabSpriteDataStore,x    ; 
                        inx                         ; 
                        bne .GetSpriteDataCopy      ; 
                        
                        inc .GetSpriteDataCopy + $02; 
                        inc .SetSpriteDataCopy + $02; 
                        
                        dey                         ; 
                        bne .GetSpriteDataCopy      ; 
                        
.GetSpriteDataCopyInit  lda #>TabSpriteDataOrig     ; 
                        sta .GetSpriteDataCopy + $02; 
                        
                        lda #>TabSpriteDataStore    ; 
                        sta .SetSpriteDataCopy + $02; 
                        
SpriteDataCopyX         rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_3fa1                  dc.b $99 ; 
                        dc.b $09 ; 
                        dc.b $b9 ; 
                        dc.b $3f ; 
                        dc.b $a7 ; 
                        dc.b $1f ; 
                        dc.b $99 ; 
                        dc.b $23 ; 
                        dc.b $51 ; 
                        dc.b $4d ; 
                        dc.b $45 ; 
                        dc.b $11 ; 
                        dc.b $03 ; 
                        dc.b $05 ; 
                        dc.b $21 ; 
; -------------------------------------------------------------------------------------------------------------- ;
SpriteDataRestore       sei                         ; 
                        
                        lda #B_Koff                 ; 
                        sta R6510                   ; 
                        
                        ldx #$00                    ; 
                        ldy #$1e                    ; 
.GetSpriteDataRestore   lda TabSpriteDataStore,x    ; 
.SetSpriteDataRestore   sta TabSpriteDataOrig,x     ; 
                        
                        inx                         ; 
                        bne .GetSpriteDataRestore   ; 
                        
                        inc .GetSpriteDataRestore + $02 ; 
                        inc .SetSpriteDataRestore + $02 ; 
                        
                        dey                         ; 
                        bne .GetSpriteDataRestore   ; 
                        
                        lda #>TabSpriteDataStore    ; 
                        sta .GetSpriteDataRestore + $02 ; 
                        
                        lda #>TabSpriteDataOrig     ; 
                        sta .SetSpriteDataRestore + $02 ; 
                        
                        lda #BIKon                  ; 
                        sta R6510                   ; 
                        
SpriteDataRestoreX      jmp .GetSpriteDataCopyInit  ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_3fdc                  dc.b $02 ; 
                        dc.b $29 ; 
                        dc.b $30 ; 
                        dc.b $00 ; 
A_3fe0                  dc.b $b4 ; 
                        dc.b $3f ; 
                        dc.b $04 ; 
                        dc.b $1d ; 
                        dc.b $8b ; 
                        dc.b $21 ; 
                        dc.b $4d ; 
                        dc.b $25 ; 
                        dc.b $92 ; 
                        dc.b $02 ; 
                        dc.b $12 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $87 ; 
                        dc.b $02 ; 
                        dc.b $18 ; 
A_3ff0                  dc.b $1b ; 
                        dc.b $16 ; 
                        dc.b $12 ; 
                        dc.b $00 ; 
                        dc.b $08 ; 
                        dc.b $48 ; 
                        dc.b $0e ; 
                        dc.b $09 ; 
                        dc.b $8b ; 
                        dc.b $08 ; 
                        dc.b $4f ; 
                        dc.b $0c ; 
                        dc.b $9f ; 
                        dc.b $0b ; 
                        dc.b $1f ; 
                        dc.b $09 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabSpriteData           equ  *
                        rorg TabSpriteDataStore
; -------------------------------------------------------------------------------------------------------------- ;
                        dc.b $00 ; copied to SpriteStore at $e000
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabSpriteDataPtrLo_Map  dc.b <SpriteData_Map_01 ; 
                        dc.b <SpriteData_Map_02 ; 
                        dc.b <SpriteData_Map_03 ; 
                        dc.b <SpriteData_Map_04 ; 
                        dc.b <SpriteData_Map_05 ; 
                        dc.b <SpriteData_Map_06 ; 
                        dc.b <SpriteData_Map_07 ; 
                        dc.b <SpriteData_Map_08 ; 
                        dc.b <SpriteData_Map_09 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabSpriteDataPtrHi_Map  dc.b >SpriteData_Map_01 ; 
                        dc.b >SpriteData_Map_02 ; 
                        dc.b >SpriteData_Map_03 ; 
                        dc.b >SpriteData_Map_04 ; 
                        dc.b >SpriteData_Map_05 ; 
                        dc.b >SpriteData_Map_06 ; 
                        dc.b >SpriteData_Map_07 ; 
                        dc.b >SpriteData_Map_08 ; 
                        dc.b >SpriteData_Map_09 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabSpriteDataPtrLo_Cave dc.b <SpriteData_Cave_01 ; 
                        dc.b <SpriteData_Cave_02 ; 
                        dc.b <SpriteData_Cave_03 ; 
                        dc.b <SpriteData_Cave_04 ; 
                        dc.b <SpriteData_Cave_05 ; 
                        dc.b <SpriteData_Cave_06 ; 
                        dc.b <SpriteData_Cave_07 ; 
                        dc.b <SpriteData_Cave_08 ; 
                        dc.b <SpriteData_Cave_09 ; 
                        dc.b <SpriteData_Cave_10 ; 
                        dc.b <SpriteData_Cave_11 ; 
                        dc.b <SpriteData_Cave_12 ; 
                        dc.b <SpriteData_Cave_13 ; 
                        dc.b <SpriteData_Cave_14 ; 
                        dc.b <SpriteData_Cave_15 ; 
                        dc.b <SpriteData_Cave_16 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabSpriteDataPtrHi_Cave dc.b >SpriteData_Cave_01 ; 
                        dc.b >SpriteData_Cave_02 ; 
                        dc.b >SpriteData_Cave_03 ; 
                        dc.b >SpriteData_Cave_04 ; 
                        dc.b >SpriteData_Cave_05 ; 
                        dc.b >SpriteData_Cave_06 ; 
                        dc.b >SpriteData_Cave_07 ; 
                        dc.b >SpriteData_Cave_08 ; 
                        dc.b >SpriteData_Cave_09 ; 
                        dc.b >SpriteData_Cave_10 ; 
                        dc.b >SpriteData_Cave_11 ; 
                        dc.b >SpriteData_Cave_12 ; 
                        dc.b >SpriteData_Cave_13 ; 
                        dc.b >SpriteData_Cave_14 ; 
                        dc.b >SpriteData_Cave_15 ; 
                        dc.b >SpriteData_Cave_16 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabSpriteDataPtrLo_Plane dc.b <SpriteData_Plane_01 ; 
                        dc.b <SpriteData_Plane_02 ; 
                        dc.b <SpriteData_Plane_03 ; 
                        dc.b <SpriteData_Plane_04 ; 
                        dc.b <SpriteData_Plane_05 ; 
                        dc.b <SpriteData_Plane_06 ; 
                        dc.b <SpriteData_Plane_07 ; 
                        dc.b <SpriteData_Plane_08 ; 
                        dc.b <SpriteData_Plane_09 ; 
                        dc.b <SpriteData_Plane_10 ; 
                        dc.b <SpriteData_Plane_11 ; 
                        dc.b <SpriteData_Plane_12 ; 
                        dc.b <SpriteData_Plane_13 ; 
                        dc.b <SpriteData_Plane_14 ; 
                        dc.b <SpriteData_Plane_15 ; 
                        dc.b <SpriteData_Plane_16 ; 
                        dc.b <SpriteData_Plane_17 ; 
                        dc.b <SpriteData_Plane_18 ; 
                        dc.b <SpriteData_Plane_19 ; 
                        dc.b <SpriteData_Plane_20 ; 
                        dc.b <SpriteData_Plane_21 ; 
                        dc.b <SpriteData_Plane_22 ; 
                        dc.b <SpriteData_Plane_23 ; 
                        dc.b <SpriteData_Plane_24 ; 
                        dc.b <SpriteData_Plane_25 ; 
                        dc.b <SpriteData_Plane_26 ; 
                        dc.b <SpriteData_Plane_27 ; 
                        dc.b <SpriteData_Plane_28 ; 
                        dc.b <SpriteData_Plane_29 ; 
                        dc.b <SpriteData_Plane_30 ; 
                        dc.b <SpriteData_Plane_31 ; 
                        dc.b <SpriteData_Plane_32 ; 
                        dc.b <SpriteData_Plane_33 ; 
                        dc.b <SpriteData_Plane_34 ; 
                        dc.b <SpriteData_Plane_35 ; 
                        dc.b <SpriteData_Plane_36 ; 
                        dc.b <SpriteData_Plane_37 ; 
                        dc.b <SpriteData_Plane_38 ; 
                        dc.b <SpriteData_Plane_39 ; 
                        dc.b <SpriteData_Plane_40 ; 
                        dc.b <SpriteData_Plane_41 ; 
                        dc.b <SpriteData_Plane_42 ; 
                        dc.b <SpriteData_Plane_43 ; 
                        dc.b <SpriteData_Plane_44 ; 
                        dc.b <SpriteData_Plane_45 ; 
                        dc.b <SpriteData_Plane_46 ; 
                        dc.b <SpriteData_Plane_47 ; 
                        dc.b <SpriteData_Plane_48 ; 
                        dc.b <SpriteData_Plane_49 ; 
                        dc.b <SpriteData_Plane_50 ; 
                        dc.b <SpriteData_Plane_51 ; 
                        dc.b <SpriteData_Plane_52 ; 
                        dc.b <SpriteData_Plane_53 ; 
                        dc.b <SpriteData_Plane_54 ; 
                        dc.b <SpriteData_Plane_55 ; 
                        dc.b <SpriteData_Plane_56 ; 
                        dc.b <SpriteData_Plane_57 ; 
                        dc.b <SpriteData_Plane_58 ; 
                        dc.b <SpriteData_Plane_59 ; 
                        dc.b <SpriteData_Plane_60 ; 
                        dc.b <SpriteData_Plane_61 ; 
                        dc.b <SpriteData_Plane_62 ; 
                        dc.b <SpriteData_Plane_63 ; 
                        dc.b <SpriteData_Plane_64 ; 
                        dc.b <SpriteData_Plane_65 ; 
                        dc.b <SpriteData_Plane_66 ; 
                        dc.b <SpriteData_Plane_67 ; 
                        dc.b <SpriteData_Plane_68 ; 
                        dc.b <SpriteData_Plane_69 ; 
                        dc.b <SpriteData_Plane_70 ; 
                        dc.b <SpriteData_Plane_71 ; 
                        dc.b <SpriteData_Plane_72 ; 
                        dc.b <SpriteData_Plane_73 ; 
                        dc.b <SpriteData_Plane_74 ; 
                        dc.b <SpriteData_Plane_75 ; 
                        dc.b <SpriteData_Plane_76 ; 
                        dc.b <SpriteData_Plane_77 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabSpriteDataPtrHi_Plane dc.b >SpriteData_Plane_01 ; 
                        dc.b >SpriteData_Plane_02 ; 
                        dc.b >SpriteData_Plane_03 ; 
                        dc.b >SpriteData_Plane_04 ; 
                        dc.b >SpriteData_Plane_05 ; 
                        dc.b >SpriteData_Plane_06 ; 
                        dc.b >SpriteData_Plane_07 ; 
                        dc.b >SpriteData_Plane_08 ; 
                        dc.b >SpriteData_Plane_09 ; 
                        dc.b >SpriteData_Plane_10 ; 
                        dc.b >SpriteData_Plane_11 ; 
                        dc.b >SpriteData_Plane_12 ; 
                        dc.b >SpriteData_Plane_13 ; 
                        dc.b >SpriteData_Plane_14 ; 
                        dc.b >SpriteData_Plane_15 ; 
                        dc.b >SpriteData_Plane_16 ; 
                        dc.b >SpriteData_Plane_17 ; 
                        dc.b >SpriteData_Plane_18 ; 
                        dc.b >SpriteData_Plane_19 ; 
                        dc.b >SpriteData_Plane_20 ; 
                        dc.b >SpriteData_Plane_21 ; 
                        dc.b >SpriteData_Plane_22 ; 
                        dc.b >SpriteData_Plane_23 ; 
                        dc.b >SpriteData_Plane_24 ; 
                        dc.b >SpriteData_Plane_25 ; 
                        dc.b >SpriteData_Plane_26 ; 
                        dc.b >SpriteData_Plane_27 ; 
                        dc.b >SpriteData_Plane_28 ; 
                        dc.b >SpriteData_Plane_29 ; 
                        dc.b >SpriteData_Plane_30 ; 
                        dc.b >SpriteData_Plane_31 ; 
                        dc.b >SpriteData_Plane_32 ; 
                        dc.b >SpriteData_Plane_33 ; 
                        dc.b >SpriteData_Plane_34 ; 
                        dc.b >SpriteData_Plane_35 ; 
                        dc.b >SpriteData_Plane_36 ; 
                        dc.b >SpriteData_Plane_37 ; 
                        dc.b >SpriteData_Plane_38 ; 
                        dc.b >SpriteData_Plane_39 ; 
                        dc.b >SpriteData_Plane_40 ; 
                        dc.b >SpriteData_Plane_41 ; 
                        dc.b >SpriteData_Plane_42 ; 
                        dc.b >SpriteData_Plane_43 ; 
                        dc.b >SpriteData_Plane_44 ; 
                        dc.b >SpriteData_Plane_45 ; 
                        dc.b >SpriteData_Plane_46 ; 
                        dc.b >SpriteData_Plane_47 ; 
                        dc.b >SpriteData_Plane_48 ; 
                        dc.b >SpriteData_Plane_49 ; 
                        dc.b >SpriteData_Plane_50 ; 
                        dc.b >SpriteData_Plane_51 ; 
                        dc.b >SpriteData_Plane_52 ; 
                        dc.b >SpriteData_Plane_53 ; 
                        dc.b >SpriteData_Plane_54 ; 
                        dc.b >SpriteData_Plane_55 ; 
                        dc.b >SpriteData_Plane_56 ; 
                        dc.b >SpriteData_Plane_57 ; 
                        dc.b >SpriteData_Plane_58 ; 
                        dc.b >SpriteData_Plane_59 ; 
                        dc.b >SpriteData_Plane_60 ; 
                        dc.b >SpriteData_Plane_61 ; 
                        dc.b >SpriteData_Plane_62 ; 
                        dc.b >SpriteData_Plane_63 ; 
                        dc.b >SpriteData_Plane_64 ; 
                        dc.b >SpriteData_Plane_65 ; 
                        dc.b >SpriteData_Plane_66 ; 
                        dc.b >SpriteData_Plane_67 ; 
                        dc.b >SpriteData_Plane_68 ; 
                        dc.b >SpriteData_Plane_69 ; 
                        dc.b >SpriteData_Plane_70 ; 
                        dc.b >SpriteData_Plane_71 ; 
                        dc.b >SpriteData_Plane_72 ; 
                        dc.b >SpriteData_Plane_73 ; 
                        dc.b >SpriteData_Plane_74 ; 
                        dc.b >SpriteData_Plane_75 ; 
                        dc.b >SpriteData_Plane_76 ; 
                        dc.b >SpriteData_Plane_77 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabSpriteDataPtrLo_Ship dc.b <SpriteData_Ship_01 ; 
                        dc.b <SpriteData_Ship_02 ; 
                        dc.b <SpriteData_Ship_03 ; 
                        dc.b <SpriteData_Ship_04 ; 
                        dc.b <SpriteData_Ship_05 ; 
                        dc.b <SpriteData_Ship_06 ; 
                        dc.b <SpriteData_Ship_07 ; 
                        dc.b <SpriteData_Ship_08 ; 
                        dc.b <SpriteData_Ship_09 ; 
                        dc.b <SpriteData_Ship_10 ; 
                        dc.b <SpriteData_Ship_11 ; 
                        dc.b <SpriteData_Ship_12 ; 
                        dc.b <SpriteData_Ship_13 ; 
                        dc.b <SpriteData_Ship_14 ; 
                        dc.b <SpriteData_Ship_15 ; 
                        dc.b <SpriteData_Ship_16 ; 
                        dc.b <SpriteData_Ship_17 ; 
                        dc.b <SpriteData_Ship_18 ; 
                        dc.b <SpriteData_Ship_19 ; 
                        dc.b <SpriteData_Ship_20 ; 
                        dc.b <SpriteData_Ship_21 ; 
                        dc.b <SpriteData_Ship_22 ; 
                        dc.b <SpriteData_Ship_23 ; 
                        dc.b <SpriteData_Ship_24 ; 
                        dc.b <SpriteData_Ship_25 ; 
                        dc.b <SpriteData_Ship_26 ; 
                        dc.b <SpriteData_Ship_27 ; 
                        dc.b <SpriteData_Ship_28 ; 
                        dc.b <SpriteData_Ship_29 ; 
                        dc.b <SpriteData_Ship_30 ; 
                        dc.b <SpriteData_Ship_31 ; 
                        dc.b <SpriteData_Ship_32 ; 
                        dc.b <SpriteData_Ship_33 ; 
                        dc.b <SpriteData_Ship_34 ; 
                        dc.b <SpriteData_Ship_35 ; 
                        dc.b <SpriteData_Ship_36 ; 
                        dc.b <SpriteData_Ship_37 ; 
                        dc.b <SpriteData_Ship_38 ; 
                        dc.b <SpriteData_Ship_39 ; 
                        dc.b <SpriteData_Ship_40 ; 
                        dc.b <SpriteData_Ship_41 ; 
                        dc.b <SpriteData_Ship_42 ; 
                        dc.b <SpriteData_Ship_43 ; 
                        dc.b <SpriteData_Ship_44 ; 
                        dc.b <SpriteData_Ship_45 ; 
                        dc.b <SpriteData_Ship_46 ; 
                        dc.b <SpriteData_Ship_47 ; 
                        dc.b <SpriteData_Ship_48 ; 
                        dc.b <SpriteData_Ship_49 ; 
                        dc.b <SpriteData_Ship_50 ; 
                        dc.b <SpriteData_Ship_51 ; 
                        dc.b <SpriteData_Ship_52 ; 
                        dc.b <SpriteData_Ship_53 ; 
                        dc.b <SpriteData_Ship_54 ; 
                        dc.b <SpriteData_Ship_55 ; 
                        dc.b <SpriteData_Ship_56 ; 
                        dc.b <SpriteData_Ship_57 ; 
                        dc.b <SpriteData_Ship_58 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabSpriteDataPtrHi_Ship dc.b >SpriteData_Ship_01 ; 
                        dc.b >SpriteData_Ship_02 ; 
                        dc.b >SpriteData_Ship_03 ; 
                        dc.b >SpriteData_Ship_04 ; 
                        dc.b >SpriteData_Ship_05 ; 
                        dc.b >SpriteData_Ship_06 ; 
                        dc.b >SpriteData_Ship_07 ; 
                        dc.b >SpriteData_Ship_08 ; 
                        dc.b >SpriteData_Ship_09 ; 
                        dc.b >SpriteData_Ship_10 ; 
                        dc.b >SpriteData_Ship_11 ; 
                        dc.b >SpriteData_Ship_12 ; 
                        dc.b >SpriteData_Ship_13 ; 
                        dc.b >SpriteData_Ship_14 ; 
                        dc.b >SpriteData_Ship_15 ; 
                        dc.b >SpriteData_Ship_16 ; 
                        dc.b >SpriteData_Ship_17 ; 
                        dc.b >SpriteData_Ship_18 ; 
                        dc.b >SpriteData_Ship_19 ; 
                        dc.b >SpriteData_Ship_20 ; 
                        dc.b >SpriteData_Ship_21 ; 
                        dc.b >SpriteData_Ship_22 ; 
                        dc.b >SpriteData_Ship_23 ; 
                        dc.b >SpriteData_Ship_24 ; 
                        dc.b >SpriteData_Ship_25 ; 
                        dc.b >SpriteData_Ship_26 ; 
                        dc.b >SpriteData_Ship_27 ; 
                        dc.b >SpriteData_Ship_28 ; 
                        dc.b >SpriteData_Ship_29 ; 
                        dc.b >SpriteData_Ship_30 ; 
                        dc.b >SpriteData_Ship_31 ; 
                        dc.b >SpriteData_Ship_32 ; 
                        dc.b >SpriteData_Ship_33 ; 
                        dc.b >SpriteData_Ship_34 ; 
                        dc.b >SpriteData_Ship_35 ; 
                        dc.b >SpriteData_Ship_36 ; 
                        dc.b >SpriteData_Ship_37 ; 
                        dc.b >SpriteData_Ship_38 ; 
                        dc.b >SpriteData_Ship_39 ; 
                        dc.b >SpriteData_Ship_40 ; 
                        dc.b >SpriteData_Ship_41 ; 
                        dc.b >SpriteData_Ship_42 ; 
                        dc.b >SpriteData_Ship_43 ; 
                        dc.b >SpriteData_Ship_44 ; 
                        dc.b >SpriteData_Ship_45 ; 
                        dc.b >SpriteData_Ship_46 ; 
                        dc.b >SpriteData_Ship_47 ; 
                        dc.b >SpriteData_Ship_48 ; 
                        dc.b >SpriteData_Ship_49 ; 
                        dc.b >SpriteData_Ship_50 ; 
                        dc.b >SpriteData_Ship_51 ; 
                        dc.b >SpriteData_Ship_52 ; 
                        dc.b >SpriteData_Ship_53 ; 
                        dc.b >SpriteData_Ship_54 ; 
                        dc.b >SpriteData_Ship_55 ; 
                        dc.b >SpriteData_Ship_56 ; 
                        dc.b >SpriteData_Ship_57 ; 
                        dc.b >SpriteData_Ship_58 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabSpriteDataPtrLo_Tank dc.b <SpriteData_Tank_01 ; 
                        dc.b <SpriteData_Tank_02 ; 
                        dc.b <SpriteData_Tank_03 ; 
                        dc.b <SpriteData_Tank_04 ; 
                        dc.b <SpriteData_Tank_05 ; 
                        dc.b <SpriteData_Tank_06 ; 
                        dc.b <SpriteData_Tank_07 ; 
                        dc.b <SpriteData_Tank_08 ; 
                        dc.b <SpriteData_Tank_09 ; 
                        dc.b <SpriteData_Tank_10 ; 
                        dc.b <SpriteData_Tank_11 ; 
                        dc.b <SpriteData_Tank_12 ; 
                        dc.b <SpriteData_Tank_13 ; 
                        dc.b <SpriteData_Tank_14 ; 
                        dc.b <SpriteData_Tank_15 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabSpriteDataPtrHi_Tank dc.b >SpriteData_Tank_01 ; 
                        dc.b >SpriteData_Tank_02 ; 
                        dc.b >SpriteData_Tank_03 ; 
                        dc.b >SpriteData_Tank_04 ; 
                        dc.b >SpriteData_Tank_05 ; 
                        dc.b >SpriteData_Tank_06 ; 
                        dc.b >SpriteData_Tank_07 ; 
                        dc.b >SpriteData_Tank_08 ; 
                        dc.b >SpriteData_Tank_09 ; 
                        dc.b >SpriteData_Tank_10 ; 
                        dc.b >SpriteData_Tank_11 ; 
                        dc.b >SpriteData_Tank_12 ; 
                        dc.b >SpriteData_Tank_13 ; 
                        dc.b >SpriteData_Tank_14 ; 
                        dc.b >SpriteData_Tank_15 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabSpriteDataPtrLo_Hill dc.b <SpriteData_Hill_01 ; 
                        dc.b <SpriteData_Hill_02 ; 
                        dc.b <SpriteData_Hill_03 ; 
                        dc.b <SpriteData_Hill_04 ; 
                        dc.b <SpriteData_Hill_05 ; 
                        dc.b <SpriteData_Hill_06 ; 
                        dc.b <SpriteData_Hill_07 ; 
                        dc.b <SpriteData_Hill_08 ; 
                        dc.b <SpriteData_Hill_09 ; 
                        dc.b <SpriteData_Hill_10 ; 
                        dc.b <SpriteData_Hill_11 ; 
                        dc.b <SpriteData_Hill_12 ; 
                        dc.b <SpriteData_Hill_13 ; 
                        dc.b <SpriteData_Hill_14 ; 
                        dc.b <SpriteData_Hill_15 ; 
                        dc.b <SpriteData_Hill_16 ; 
                        dc.b <SpriteData_Hill_17 ; 
                        dc.b <SpriteData_Hill_18 ; 
                        dc.b <SpriteData_Hill_19 ; 
                        dc.b <SpriteData_Hill_20 ; 
                        dc.b <SpriteData_Hill_21 ; 
                        dc.b <SpriteData_Hill_22 ; 
                        dc.b <SpriteData_Hill_23 ; 
                        dc.b <SpriteData_Hill_24 ; 
                        dc.b <SpriteData_Hill_25 ; 
                        dc.b <SpriteData_Hill_26 ; 
                        dc.b <SpriteData_Hill_27 ; 
                        dc.b <SpriteData_Hill_28 ; 
                        dc.b <SpriteData_Hill_29 ; 
                        dc.b <SpriteData_Hill_30 ; 
                        dc.b <SpriteData_Hill_31 ; 
                        dc.b <SpriteData_Hill_32 ; 
                        dc.b <SpriteData_Hill_33 ; 
                        dc.b <SpriteData_Hill_34 ; 
                        dc.b <SpriteData_Hill_35 ; 
                        dc.b <SpriteData_Hill_36 ; 
                        dc.b <SpriteData_Hill_37 ; 
                        dc.b <SpriteData_Hill_38 ; 
                        dc.b <SpriteData_Hill_39 ; 
                        dc.b <SpriteData_Hill_40 ; 
                        dc.b <SpriteData_Hill_41 ; 
                        dc.b <SpriteData_Hill_42 ; 
                        dc.b <SpriteData_Hill_43 ; 
                        dc.b <SpriteData_Hill_44 ; 
                        dc.b <SpriteData_Hill_45 ; 
                        dc.b <SpriteData_Hill_46 ; 
                        dc.b <SpriteData_Hill_47 ; 
                        dc.b <SpriteData_Hill_48 ; 
                        dc.b <SpriteData_Hill_49 ; 
                        dc.b <SpriteData_Hill_50 ; 
                        dc.b <SpriteData_Hill_51 ; 
                        dc.b <SpriteData_Hill_52 ; 
                        dc.b <SpriteData_Hill_53 ; 
                        dc.b <SpriteData_Hill_54 ; 
                        dc.b <SpriteData_Hill_55 ; 
                        dc.b <SpriteData_Hill_56 ; 
                        dc.b <SpriteData_Hill_57 ; 
                        dc.b <SpriteData_Hill_58 ; 
                        dc.b <SpriteData_Hill_59 ; 
                        dc.b <SpriteData_Hill_60 ; 
                        dc.b <SpriteData_Hill_61 ; 
                        dc.b <SpriteData_Hill_62 ; 
                        dc.b <SpriteData_Hill_63 ; 
                        dc.b <SpriteData_Hill_64 ; 
                        dc.b <SpriteData_Hill_65 ; 
                        dc.b <SpriteData_Hill_66 ; 
                        dc.b <SpriteData_Hill_67 ; 
                        dc.b <SpriteData_Hill_68 ; 
                        dc.b <SpriteData_Hill_69 ; 
                        dc.b <SpriteData_Hill_70 ; 
                        dc.b <SpriteData_Hill_71 ; 
                        dc.b <SpriteData_Hill_72 ; 
                        dc.b <SpriteData_Hill_73 ; 
                        dc.b <SpriteData_Hill_74 ; 
                        dc.b <SpriteData_Hill_75 ; 
                        dc.b <SpriteData_Hill_76 ; 
                        dc.b <SpriteData_Hill_77 ; 
                        dc.b <SpriteData_Hill_78 ; 
                        dc.b $e8 ; 
                        dc.b $ec ; 
                        dc.b $f2 ; 
                        dc.b $fa ; 
                        dc.b $04 ; 
                        dc.b $10 ; 
                        dc.b $1e ; 
                        dc.b $2e ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabSpriteDataPtrHi_Hill dc.b >SpriteData_Hill_01 ; 
                        dc.b >SpriteData_Hill_02 ; 
                        dc.b >SpriteData_Hill_03 ; 
                        dc.b >SpriteData_Hill_04 ; 
                        dc.b >SpriteData_Hill_05 ; 
                        dc.b >SpriteData_Hill_06 ; 
                        dc.b >SpriteData_Hill_07 ; 
                        dc.b >SpriteData_Hill_08 ; 
                        dc.b >SpriteData_Hill_09 ; 
                        dc.b >SpriteData_Hill_10 ; 
                        dc.b >SpriteData_Hill_11 ; 
                        dc.b >SpriteData_Hill_12 ; 
                        dc.b >SpriteData_Hill_13 ; 
                        dc.b >SpriteData_Hill_14 ; 
                        dc.b >SpriteData_Hill_15 ; 
                        dc.b >SpriteData_Hill_16 ; 
                        dc.b >SpriteData_Hill_17 ; 
                        dc.b >SpriteData_Hill_18 ; 
                        dc.b >SpriteData_Hill_19 ; 
                        dc.b >SpriteData_Hill_20 ; 
                        dc.b >SpriteData_Hill_21 ; 
                        dc.b >SpriteData_Hill_22 ; 
                        dc.b >SpriteData_Hill_23 ; 
                        dc.b >SpriteData_Hill_24 ; 
                        dc.b >SpriteData_Hill_25 ; 
                        dc.b >SpriteData_Hill_26 ; 
                        dc.b >SpriteData_Hill_27 ; 
                        dc.b >SpriteData_Hill_28 ; 
                        dc.b >SpriteData_Hill_29 ; 
                        dc.b >SpriteData_Hill_30 ; 
                        dc.b >SpriteData_Hill_31 ; 
                        dc.b >SpriteData_Hill_32 ; 
                        dc.b >SpriteData_Hill_33 ; 
                        dc.b >SpriteData_Hill_34 ; 
                        dc.b >SpriteData_Hill_35 ; 
                        dc.b >SpriteData_Hill_36 ; 
                        dc.b >SpriteData_Hill_37 ; 
                        dc.b >SpriteData_Hill_38 ; 
                        dc.b >SpriteData_Hill_39 ; 
                        dc.b >SpriteData_Hill_40 ; 
                        dc.b >SpriteData_Hill_41 ; 
                        dc.b >SpriteData_Hill_42 ; 
                        dc.b >SpriteData_Hill_43 ; 
                        dc.b >SpriteData_Hill_44 ; 
                        dc.b >SpriteData_Hill_45 ; 
                        dc.b >SpriteData_Hill_46 ; 
                        dc.b >SpriteData_Hill_47 ; 
                        dc.b >SpriteData_Hill_48 ; 
                        dc.b >SpriteData_Hill_49 ; 
                        dc.b >SpriteData_Hill_50 ; 
                        dc.b >SpriteData_Hill_51 ; 
                        dc.b >SpriteData_Hill_52 ; 
                        dc.b >SpriteData_Hill_53 ; 
                        dc.b >SpriteData_Hill_54 ; 
                        dc.b >SpriteData_Hill_55 ; 
                        dc.b >SpriteData_Hill_56 ; 
                        dc.b >SpriteData_Hill_57 ; 
                        dc.b >SpriteData_Hill_58 ; 
                        dc.b >SpriteData_Hill_59 ; 
                        dc.b >SpriteData_Hill_60 ; 
                        dc.b >SpriteData_Hill_61 ; 
                        dc.b >SpriteData_Hill_62 ; 
                        dc.b >SpriteData_Hill_63 ; 
                        dc.b >SpriteData_Hill_64 ; 
                        dc.b >SpriteData_Hill_65 ; 
                        dc.b >SpriteData_Hill_66 ; 
                        dc.b >SpriteData_Hill_67 ; 
                        dc.b >SpriteData_Hill_68 ; 
                        dc.b >SpriteData_Hill_69 ; 
                        dc.b >SpriteData_Hill_70 ; 
                        dc.b >SpriteData_Hill_71 ; 
                        dc.b >SpriteData_Hill_72 ; 
                        dc.b >SpriteData_Hill_73 ; 
                        dc.b >SpriteData_Hill_74 ; 
                        dc.b >SpriteData_Hill_75 ; 
                        dc.b >SpriteData_Hill_76 ; 
                        dc.b >SpriteData_Hill_77 ; 
                        dc.b >SpriteData_Hill_78 ; 
                        dc.b $ea ; 
                        dc.b $ea ; 
                        dc.b $ea ; 
                        dc.b $ea ; 
                        dc.b $eb ; 
                        dc.b $eb ; 
                        dc.b $eb ; 
                        dc.b $eb ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_4340                  dc.b $3e ; ..#####.
                        dc.b $5d ; .#.###.#
; -------------------------------------------------------------------------------------------------------------- ;
SpriteData_Plane_01     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1f ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_02     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1f ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_03     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1c ; 
                        dc.b $18 ; ...##...
                        dc.b $1f ; 
                        dc.b $7e ; .######.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_04     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1c ; 
                        dc.b $18 ; ...##...
                        dc.b $1e ; 
                        dc.b $01 ; .......#
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $80 ; #.......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_05     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1c ; 
                        dc.b $18 ; ...##...
                        dc.b $1e ; 
                        dc.b $07 ; .....###
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $e0 ; ###.....
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_06     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ; 
                        dc.b $18 ; ...##...
                        dc.b $1c ; 
                        dc.b $18 ; ...##...
                        dc.b $1e ; 
                        dc.b $1f ; ...#####
                        dc.b $1f ; 
                        dc.b $e7 ; ###..###
                        dc.b $20 ; 
                        dc.b $f8 ; #####...
                        dc.b $21 ; 
                        dc.b $01 ; .......#
                        dc.b $22 ; 
                        dc.b $81 ; #......#
                        dc.b $23 ; 
                        dc.b $80 ; #.......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_07     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ; 
                        dc.b $18 ; ...##...
                        dc.b $1c ; 
                        dc.b $18 ; ...##...
                        dc.b $1e ; 
                        dc.b $7f ; .#######
                        dc.b $1f ; 
                        dc.b $e7 ; ###..###
                        dc.b $20 ; 
                        dc.b $fe ; #######.
                        dc.b $21 ; 
                        dc.b $03 ; ......##
                        dc.b $23 ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_08     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $17 ; 
                        dc.b $01 ; .......#
                        dc.b $1a ; 
                        dc.b $01 ; .......#
                        dc.b $1d ; 
                        dc.b $03 ; ......##
                        dc.b $1f ; 
                        dc.b $1f ; ...#####
                        dc.b $20 ; 
                        dc.b $fc ; ######..
                        dc.b $23 ; 
                        dc.b $60 ; .##.....
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_09     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $15 ; 
                        dc.b $80 ; #.......
                        dc.b $18 ; 
                        dc.b $80 ; #.......
                        dc.b $1b ; 
                        dc.b $c0 ; ##......
                        dc.b $1e ; 
                        dc.b $3f ; ..######
                        dc.b $1f ; 
                        dc.b $f8 ; #####...
                        dc.b $21 ; 
                        dc.b $07 ; .....###
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_10     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $17 ; 
                        dc.b $01 ; .......#
                        dc.b $1a ; 
                        dc.b $01 ; .......#
                        dc.b $1d ; 
                        dc.b $07 ; .....###
                        dc.b $1f ; 
                        dc.b $7f ; .#######
                        dc.b $20 ; 
                        dc.b $f9 ; #####..#
                        dc.b $23 ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_11     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $15 ; 
                        dc.b $80 ; #.......
                        dc.b $18 ; 
                        dc.b $80 ; #.......
                        dc.b $1b ; 
                        dc.b $e0 ; ###.....
                        dc.b $1e ; 
                        dc.b $9f ; #..#####
                        dc.b $1f ; 
                        dc.b $fe ; #######.
                        dc.b $21 ; 
                        dc.b $03 ; ......##
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_12     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $14 ; 
                        dc.b $01 ; .......#
                        dc.b $17 ; 
                        dc.b $05 ; .....#.#
                        dc.b $1a ; 
                        dc.b $01 ; .......#
                        dc.b $1d ; 
                        dc.b $07 ; .....###
                        dc.b $1e ; 
                        dc.b $01 ; .......#
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $f9 ; #####..#
                        dc.b $22 ; 
                        dc.b $01 ; .......#
                        dc.b $23 ; 
                        dc.b $80 ; #.......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_13     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $12 ; 
                        dc.b $80 ; #.......
                        dc.b $15 ; 
                        dc.b $a0 ; #.#.....
                        dc.b $18 ; 
                        dc.b $80 ; #.......
                        dc.b $1b ; 
                        dc.b $e0 ; ###.....
                        dc.b $1e ; 
                        dc.b $9f ; #..#####
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $80 ; #.......
                        dc.b $21 ; 
                        dc.b $01 ; .......#
                        dc.b $22 ; 
                        dc.b $80 ; #.......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_14     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $14 ; 
                        dc.b $01 ; .......#
                        dc.b $17 ; 
                        dc.b $05 ; .....#.#
                        dc.b $1a ; 
                        dc.b $01 ; .......#
                        dc.b $1d ; 
                        dc.b $0f ; ....####
                        dc.b $1e ; 
                        dc.b $07 ; .....###
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $f1 ; ####...#
                        dc.b $22 ; 
                        dc.b $03 ; ......##
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_15     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0f ; 
                        dc.b $80 ; #.......
                        dc.b $12 ; 
                        dc.b $80 ; #.......
                        dc.b $15 ; 
                        dc.b $a0 ; #.#.....
                        dc.b $18 ; 
                        dc.b $80 ; #.......
                        dc.b $1b ; 
                        dc.b $f0 ; ####....
                        dc.b $1e ; 
                        dc.b $8f ; #...####
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $e0 ; ###.....
                        dc.b $22 ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_16     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $11 ; 
                        dc.b $01 ; .......#
                        dc.b $14 ; 
                        dc.b $0d ; ....##.#
                        dc.b $17 ; 
                        dc.b $01 ; .......#
                        dc.b $1a ; 
                        dc.b $03 ; ......##
                        dc.b $1d ; 
                        dc.b $1f ; ...#####
                        dc.b $1e ; 
                        dc.b $1f ; ...#####
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $f1 ; ####...#
                        dc.b $22 ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_17     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0f ; 
                        dc.b $80 ; #.......
                        dc.b $12 ; 
                        dc.b $b0 ; #.##....
                        dc.b $15 ; 
                        dc.b $80 ; #.......
                        dc.b $18 ; 
                        dc.b $c0 ; ##......
                        dc.b $1b ; 
                        dc.b $f8 ; #####...
                        dc.b $1e ; 
                        dc.b $8f ; #...####
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $f8 ; #####...
                        dc.b $22 ; 
                        dc.b $60 ; .##.....
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_18     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $14 ; 
                        dc.b $01 ; .......#
                        dc.b $17 ; 
                        dc.b $0b ; ....#.##
                        dc.b $1a ; 
                        dc.b $03 ; ......##
                        dc.b $1d ; 
                        dc.b $1f ; ...#####
                        dc.b $1e ; 
                        dc.b $1f ; ...#####
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $ff ; ########
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $23 ; 
                        dc.b $f1 ; ####...#
                        dc.b $25 ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_19     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $12 ; 
                        dc.b $80 ; #.......
                        dc.b $15 ; 
                        dc.b $d0 ; ##.#....
                        dc.b $18 ; 
                        dc.b $c0 ; ##......
                        dc.b $1b ; 
                        dc.b $f8 ; #####...
                        dc.b $1e ; 
                        dc.b $ff ; ########
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $f8 ; #####...
                        dc.b $21 ; 
                        dc.b $8f ; #...####
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $25 ; 
                        dc.b $60 ; .##.....
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_20     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0e ; 
                        dc.b $01 ; .......#
                        dc.b $11 ; 
                        dc.b $01 ; .......#
                        dc.b $14 ; 
                        dc.b $03 ; ......##
                        dc.b $17 ; 
                        dc.b $03 ; ......##
                        dc.b $1a ; 
                        dc.b $07 ; .....###
                        dc.b $1c ; 
                        dc.b $04 ; .....#..
                        dc.b $1d ; 
                        dc.b $1f ; ...#####
                        dc.b $1e ; 
                        dc.b $1f ; ...#####
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $ff ; ########
                        dc.b $21 ; 
                        dc.b $07 ; .....###
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $23 ; 
                        dc.b $f3 ; ####..##
                        dc.b $25 ; 
                        dc.b $06 ; .....##.
                        dc.b $26 ; 
                        dc.b $01 ; .......#
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_21     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0c ; 
                        dc.b $80 ; #.......
                        dc.b $0f ; 
                        dc.b $80 ; #.......
                        dc.b $12 ; 
                        dc.b $c0 ; ##......
                        dc.b $15 ; 
                        dc.b $c0 ; ##......
                        dc.b $18 ; 
                        dc.b $e0 ; ###.....
                        dc.b $1b ; 
                        dc.b $f8 ; #####...
                        dc.b $1c ; 
                        dc.b $20 ; ..#.....
                        dc.b $1e ; 
                        dc.b $ff ; ########
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $f8 ; #####...
                        dc.b $21 ; 
                        dc.b $cf ; ##..####
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $23 ; 
                        dc.b $e0 ; ###.....
                        dc.b $24 ; 
                        dc.b $80 ; #.......
                        dc.b $25 ; 
                        dc.b $60 ; .##.....
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_22     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $08 ; 
                        dc.b $01 ; .......#
                        dc.b $0b ; 
                        dc.b $01 ; .......#
                        dc.b $0e ; 
                        dc.b $03 ; ......##
                        dc.b $11 ; 
                        dc.b $03 ; ......##
                        dc.b $14 ; 
                        dc.b $03 ; ......##
                        dc.b $17 ; 
                        dc.b $07 ; .....###
                        dc.b $19 ; 
                        dc.b $0c ; ....##..
                        dc.b $1a ; 
                        dc.b $1f ; ...#####
                        dc.b $1b ; 
                        dc.b $1f ; ...#####
                        dc.b $1c ; 
                        dc.b $ff ; ########
                        dc.b $1d ; 
                        dc.b $ff ; ########
                        dc.b $1e ; 
                        dc.b $0f ; ....####
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $fb ; #####.##
                        dc.b $21 ; 
                        dc.b $03 ; ......##
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $23 ; 
                        dc.b $e3 ; ###...##
                        dc.b $25 ; 
                        dc.b $06 ; .....##.
                        dc.b $26 ; 
                        dc.b $09 ; ....#..#
                        dc.b $29 ; 
                        dc.b $01 ; .......#
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_23     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $06 ; 
                        dc.b $80 ; #.......
                        dc.b $09 ; 
                        dc.b $80 ; #.......
                        dc.b $0c ; 
                        dc.b $c0 ; ##......
                        dc.b $0f ; 
                        dc.b $c0 ; ##......
                        dc.b $12 ; 
                        dc.b $c0 ; ##......
                        dc.b $15 ; 
                        dc.b $e0 ; ###.....
                        dc.b $18 ; 
                        dc.b $f8 ; #####...
                        dc.b $19 ; 
                        dc.b $30 ; ..##....
                        dc.b $1b ; 
                        dc.b $ff ; ########
                        dc.b $1c ; 
                        dc.b $ff ; ########
                        dc.b $1d ; 
                        dc.b $f8 ; #####...
                        dc.b $1e ; 
                        dc.b $df ; ##.#####
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $f0 ; ####....
                        dc.b $21 ; 
                        dc.b $c7 ; ##...###
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $23 ; 
                        dc.b $c0 ; ##......
                        dc.b $24 ; 
                        dc.b $90 ; #..#....
                        dc.b $25 ; 
                        dc.b $60 ; .##.....
                        dc.b $27 ; 
                        dc.b $80 ; #.......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_24     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $11 ; 
                        dc.b $03 ; ......##
                        dc.b $14 ; 
                        dc.b $03 ; ......##
                        dc.b $17 ; 
                        dc.b $03 ; ......##
                        dc.b $1a ; 
                        dc.b $03 ; ......##
                        dc.b $1d ; 
                        dc.b $0f ; ....####
                        dc.b $20 ; 
                        dc.b $3f ; ..######
                        dc.b $23 ; 
                        dc.b $fc ; ######..
                        dc.b $25 ; 
                        dc.b $0f ; ....####
                        dc.b $26 ; 
                        dc.b $f0 ; ####....
                        dc.b $28 ; 
                        dc.b $fc ; ######..
                        dc.b $2a ; 
                        dc.b $07 ; .....###
                        dc.b $2b ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_25     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0b ; 
                        dc.b $38 ; ..###...
                        dc.b $0e ; 
                        dc.b $e0 ; ###.....
                        dc.b $10 ; 
                        dc.b $0f ; ....####
                        dc.b $11 ; 
                        dc.b $80 ; #.......
                        dc.b $12 ; 
                        dc.b $80 ; #.......
                        dc.b $13 ; 
                        dc.b $fc ; ######..
                        dc.b $15 ; 
                        dc.b $ff ; ########
                        dc.b $16 ; 
                        dc.b $c0 ; ##......
                        dc.b $18 ; 
                        dc.b $ff ; ########
                        dc.b $1b ; 
                        dc.b $e0 ; ###.....
                        dc.b $1e ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_26     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $11 ; 
                        dc.b $1c ; ...###..
                        dc.b $14 ; 
                        dc.b $1e ; ...####.
                        dc.b $17 ; 
                        dc.b $0f ; ....####
                        dc.b $1a ; 
                        dc.b $0f ; ....####
                        dc.b $1d ; 
                        dc.b $07 ; .....###
                        dc.b $20 ; 
                        dc.b $1f ; ...#####
                        dc.b $23 ; 
                        dc.b $3f ; ..######
                        dc.b $25 ; 
                        dc.b $06 ; .....##.
                        dc.b $26 ; 
                        dc.b $ff ; ########
                        dc.b $28 ; 
                        dc.b $03 ; ......##
                        dc.b $29 ; 
                        dc.b $fe ; #######.
                        dc.b $2b ; 
                        dc.b $0f ; ....####
                        dc.b $2c ; 
                        dc.b $f8 ; #####...
                        dc.b $2e ; 
                        dc.b $3f ; ..######
                        dc.b $2f ; 
                        dc.b $e0 ; ###.....
                        dc.b $31 ; 
                        dc.b $ff ; ########
                        dc.b $32 ; 
                        dc.b $30 ; ..##....
                        dc.b $33 ; 
                        dc.b $03 ; ......##
                        dc.b $34 ; 
                        dc.b $f8 ; #####...
                        dc.b $36 ; 
                        dc.b $07 ; .....###
                        dc.b $37 ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_27     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $05 ; 
                        dc.b $60 ; .##.....
                        dc.b $07 ; 
                        dc.b $01 ; .......#
                        dc.b $08 ; 
                        dc.b $e0 ; ###.....
                        dc.b $0a ; 
                        dc.b $0f ; ....####
                        dc.b $0b ; 
                        dc.b $c0 ; ##......
                        dc.b $0c ; 
                        dc.b $03 ; ......##
                        dc.b $0d ; 
                        dc.b $3f ; ..######
                        dc.b $0e ; 
                        dc.b $80 ; #.......
                        dc.b $0f ; 
                        dc.b $01 ; .......#
                        dc.b $10 ; 
                        dc.b $ff ; ########
                        dc.b $12 ; 
                        dc.b $07 ; .....###
                        dc.b $13 ; 
                        dc.b $fc ; ######..
                        dc.b $15 ; 
                        dc.b $bf ; #.######
                        dc.b $16 ; 
                        dc.b $f0 ; ####....
                        dc.b $18 ; 
                        dc.b $ff ; ########
                        dc.b $19 ; 
                        dc.b $b0 ; #.##....
                        dc.b $1b ; 
                        dc.b $fe ; #######.
                        dc.b $1e ; 
                        dc.b $f8 ; #####...
                        dc.b $21 ; 
                        dc.b $f0 ; ####....
                        dc.b $24 ; 
                        dc.b $f8 ; #####...
                        dc.b $27 ; 
                        dc.b $38 ; ..###...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_28     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0e ; 
                        dc.b $38 ; ..###...
                        dc.b $11 ; 
                        dc.b $3c ; ..####..
                        dc.b $14 ; 
                        dc.b $1e ; ...####.
                        dc.b $17 ; 
                        dc.b $0f ; ....####
                        dc.b $1a ; 
                        dc.b $07 ; .....###
                        dc.b $1d ; 
                        dc.b $07 ; .....###
                        dc.b $20 ; 
                        dc.b $03 ; ......##
                        dc.b $23 ; 
                        dc.b $0f ; ....####
                        dc.b $25 ; 
                        dc.b $01 ; .......#
                        dc.b $26 ; 
                        dc.b $9f ; #..#####
                        dc.b $29 ; 
                        dc.b $ff ; ########
                        dc.b $2b ; 
                        dc.b $01 ; .......#
                        dc.b $2c ; 
                        dc.b $ff ; ########
                        dc.b $2e ; 
                        dc.b $03 ; ......##
                        dc.b $2f ; 
                        dc.b $fe ; #######.
                        dc.b $31 ; 
                        dc.b $07 ; .....###
                        dc.b $32 ; 
                        dc.b $fc ; ######..
                        dc.b $34 ; 
                        dc.b $1f ; ...#####
                        dc.b $35 ; 
                        dc.b $e6 ; ###..##.
                        dc.b $37 ; 
                        dc.b $3f ; ..######
                        dc.b $38 ; 
                        dc.b $80 ; #.......
                        dc.b $3a ; 
                        dc.b $7c ; .#####..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_29     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $01 ; 
                        dc.b $01 ; .......#
                        dc.b $02 ; 
                        dc.b $80 ; #.......
                        dc.b $04 ; 
                        dc.b $07 ; .....###
                        dc.b $05 ; 
                        dc.b $80 ; #.......
                        dc.b $07 ; 
                        dc.b $0f ; ....####
                        dc.b $08 ; 
                        dc.b $80 ; #.......
                        dc.b $09 ; 
                        dc.b $03 ; ......##
                        dc.b $0a ; 
                        dc.b $3f ; ..######
                        dc.b $0c ; 
                        dc.b $01 ; .......#
                        dc.b $0d ; 
                        dc.b $fe ; #######.
                        dc.b $0f ; 
                        dc.b $01 ; .......#
                        dc.b $10 ; 
                        dc.b $fc ; ######..
                        dc.b $12 ; 
                        dc.b $07 ; .....###
                        dc.b $13 ; 
                        dc.b $f8 ; #####...
                        dc.b $15 ; 
                        dc.b $9f ; #..#####
                        dc.b $16 ; 
                        dc.b $f0 ; ####....
                        dc.b $18 ; 
                        dc.b $ff ; ########
                        dc.b $19 ; 
                        dc.b $d8 ; ##.##...
                        dc.b $1b ; 
                        dc.b $ff ; ########
                        dc.b $1e ; 
                        dc.b $fc ; ######..
                        dc.b $21 ; 
                        dc.b $f9 ; #####..#
                        dc.b $22 ; 
                        dc.b $80 ; #.......
                        dc.b $24 ; 
                        dc.b $fc ; ######..
                        dc.b $27 ; 
                        dc.b $de ; ##.####.
                        dc.b $2a ; 
                        dc.b $0e ; ....###.
                        dc.b $2d ; 
                        dc.b $60 ; .##.....
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_30     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $09 ; 
                        dc.b $1c ; ...###..
                        dc.b $0c ; 
                        dc.b $07 ; .....###
                        dc.b $0f ; 
                        dc.b $01 ; .......#
                        dc.b $10 ; 
                        dc.b $f0 ; ####....
                        dc.b $13 ; 
                        dc.b $7e ; .######.
                        dc.b $14 ; 
                        dc.b $03 ; ......##
                        dc.b $16 ; 
                        dc.b $07 ; .....###
                        dc.b $17 ; 
                        dc.b $ff ; ########
                        dc.b $1a ; 
                        dc.b $ff ; ########
                        dc.b $1d ; 
                        dc.b $07 ; .....###
                        dc.b $20 ; 
                        dc.b $03 ; ......##
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_31     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0f ; 
                        dc.b $c0 ; ##......
                        dc.b $12 ; 
                        dc.b $c0 ; ##......
                        dc.b $15 ; 
                        dc.b $c0 ; ##......
                        dc.b $18 ; 
                        dc.b $c0 ; ##......
                        dc.b $1b ; 
                        dc.b $f0 ; ####....
                        dc.b $1e ; 
                        dc.b $fc ; ######..
                        dc.b $21 ; 
                        dc.b $3f ; ..######
                        dc.b $24 ; 
                        dc.b $0f ; ....####
                        dc.b $25 ; 
                        dc.b $f0 ; ####....
                        dc.b $28 ; 
                        dc.b $3f ; ..######
                        dc.b $2b ; 
                        dc.b $03 ; ......##
                        dc.b $2c ; 
                        dc.b $f0 ; ####....
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_32     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $03 ; 
                        dc.b $06 ; .....##.
                        dc.b $06 ; 
                        dc.b $07 ; .....###
                        dc.b $07 ; 
                        dc.b $80 ; #.......
                        dc.b $09 ; 
                        dc.b $03 ; ......##
                        dc.b $0a ; 
                        dc.b $f0 ; ####....
                        dc.b $0c ; 
                        dc.b $01 ; .......#
                        dc.b $0d ; 
                        dc.b $fc ; ######..
                        dc.b $0e ; 
                        dc.b $c0 ; ##......
                        dc.b $10 ; 
                        dc.b $ff ; ########
                        dc.b $11 ; 
                        dc.b $80 ; #.......
                        dc.b $13 ; 
                        dc.b $3f ; ..######
                        dc.b $14 ; 
                        dc.b $e0 ; ###.....
                        dc.b $16 ; 
                        dc.b $0f ; ....####
                        dc.b $17 ; 
                        dc.b $fd ; ######.#
                        dc.b $19 ; 
                        dc.b $0d ; ....##.#
                        dc.b $1a ; 
                        dc.b $ff ; ########
                        dc.b $1d ; 
                        dc.b $7f ; .#######
                        dc.b $20 ; 
                        dc.b $1f ; ...#####
                        dc.b $23 ; 
                        dc.b $0f ; ....####
                        dc.b $26 ; 
                        dc.b $1f ; ...#####
                        dc.b $29 ; 
                        dc.b $1c ; ...###..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_33     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0f ; 
                        dc.b $38 ; ..###...
                        dc.b $12 ; 
                        dc.b $78 ; .####...
                        dc.b $15 ; 
                        dc.b $f0 ; ####....
                        dc.b $18 ; 
                        dc.b $f0 ; ####....
                        dc.b $1b ; 
                        dc.b $e0 ; ###.....
                        dc.b $1e ; 
                        dc.b $f8 ; #####...
                        dc.b $21 ; 
                        dc.b $fc ; ######..
                        dc.b $24 ; 
                        dc.b $ff ; ########
                        dc.b $25 ; 
                        dc.b $60 ; .##.....
                        dc.b $27 ; 
                        dc.b $7f ; .#######
                        dc.b $28 ; 
                        dc.b $c0 ; ##......
                        dc.b $2a ; 
                        dc.b $1f ; ...#####
                        dc.b $2b ; 
                        dc.b $f0 ; ####....
                        dc.b $2d ; 
                        dc.b $07 ; .....###
                        dc.b $2e ; 
                        dc.b $fc ; ######..
                        dc.b $30 ; 
                        dc.b $0c ; ....##..
                        dc.b $31 ; 
                        dc.b $ff ; ########
                        dc.b $34 ; 
                        dc.b $1f ; ...#####
                        dc.b $35 ; 
                        dc.b $c0 ; ##......
                        dc.b $37 ; 
                        dc.b $03 ; ......##
                        dc.b $38 ; 
                        dc.b $e0 ; ###.....
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_34     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $00 ; 
                        dc.b $01 ; .......#
                        dc.b $01 ; 
                        dc.b $80 ; #.......
                        dc.b $03 ; 
                        dc.b $01 ; .......#
                        dc.b $04 ; 
                        dc.b $e0 ; ###.....
                        dc.b $06 ; 
                        dc.b $01 ; .......#
                        dc.b $07 ; 
                        dc.b $f0 ; ####....
                        dc.b $0a ; 
                        dc.b $fc ; ######..
                        dc.b $0b ; 
                        dc.b $c0 ; ##......
                        dc.b $0d ; 
                        dc.b $7f ; .#######
                        dc.b $0e ; 
                        dc.b $80 ; #.......
                        dc.b $10 ; 
                        dc.b $3f ; ..######
                        dc.b $11 ; 
                        dc.b $80 ; #.......
                        dc.b $13 ; 
                        dc.b $1f ; ...#####
                        dc.b $14 ; 
                        dc.b $e0 ; ###.....
                        dc.b $16 ; 
                        dc.b $0f ; ....####
                        dc.b $17 ; 
                        dc.b $f9 ; #####..#
                        dc.b $19 ; 
                        dc.b $1b ; ...##.##
                        dc.b $1a ; 
                        dc.b $ff ; ########
                        dc.b $1d ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $3f ; ..######
                        dc.b $22 ; 
                        dc.b $01 ; .......#
                        dc.b $23 ; 
                        dc.b $9f ; #..#####
                        dc.b $26 ; 
                        dc.b $3f ; ..######
                        dc.b $29 ; 
                        dc.b $7b ; .####.##
                        dc.b $2c ; 
                        dc.b $70 ; .###....
                        dc.b $2f ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_35     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0c ; 
                        dc.b $1c ; ...###..
                        dc.b $0f ; 
                        dc.b $3c ; ..####..
                        dc.b $12 ; 
                        dc.b $78 ; .####...
                        dc.b $15 ; 
                        dc.b $f0 ; ####....
                        dc.b $18 ; 
                        dc.b $e0 ; ###.....
                        dc.b $1b ; 
                        dc.b $e0 ; ###.....
                        dc.b $1e ; 
                        dc.b $c0 ; ##......
                        dc.b $21 ; 
                        dc.b $f0 ; ####....
                        dc.b $24 ; 
                        dc.b $f9 ; #####..#
                        dc.b $25 ; 
                        dc.b $80 ; #.......
                        dc.b $27 ; 
                        dc.b $ff ; ########
                        dc.b $2a ; 
                        dc.b $ff ; ########
                        dc.b $2b ; 
                        dc.b $80 ; #.......
                        dc.b $2d ; 
                        dc.b $7f ; .#######
                        dc.b $2e ; 
                        dc.b $c0 ; ##......
                        dc.b $30 ; 
                        dc.b $3f ; ..######
                        dc.b $31 ; 
                        dc.b $e0 ; ###.....
                        dc.b $33 ; 
                        dc.b $67 ; .##..###
                        dc.b $34 ; 
                        dc.b $f8 ; #####...
                        dc.b $36 ; 
                        dc.b $01 ; .......#
                        dc.b $37 ; 
                        dc.b $fc ; ######..
                        dc.b $3a ; 
                        dc.b $3e ; ..#####.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_01      equ  *
SpriteData_Hill_01      equ  *
SpriteData_Plane_36     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $04 ; 
                        dc.b $18 ; ...##...
                        dc.b $0a ; 
                        dc.b $18 ; ...##...
                        dc.b $10 ; 
                        dc.b $18 ; ...##...
                        dc.b $1e ; 
                        dc.b $cc ; ##..##..
                        dc.b $1f ; 
                        dc.b $18 ; ...##...
                        dc.b $20 ; 
                        dc.b $33 ; ..##..##
                        dc.b $2e ; 
                        dc.b $18 ; ...##...
                        dc.b $34 ; 
                        dc.b $18 ; ...##...
                        dc.b $3a ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_02      equ  *
SpriteData_Plane_37     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $00 ; 
                        dc.b $30 ; ..##....
                        dc.b $02 ; 
                        dc.b $0c ; ....##..
                        dc.b $03 ; 
                        dc.b $78 ; .####...
                        dc.b $05 ; 
                        dc.b $1e ; ...####.
                        dc.b $06 ; 
                        dc.b $fc ; ######..
                        dc.b $08 ; 
                        dc.b $3f ; ..######
                        dc.b $09 ; 
                        dc.b $fc ; ######..
                        dc.b $0b ; 
                        dc.b $3f ; ..######
                        dc.b $0c ; 
                        dc.b $fc ; ######..
                        dc.b $0e ; 
                        dc.b $3f ; ..######
                        dc.b $0f ; 
                        dc.b $fc ; ######..
                        dc.b $11 ; 
                        dc.b $3f ; ..######
                        dc.b $12 ; 
                        dc.b $78 ; .####...
                        dc.b $14 ; 
                        dc.b $1e ; ...####.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_03      equ  *
SpriteData_Plane_38     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $00 ; 
                        dc.b $18 ; ...##...
                        dc.b $02 ; 
                        dc.b $18 ; ...##...
                        dc.b $03 ; 
                        dc.b $3c ; ..####..
                        dc.b $05 ; 
                        dc.b $3c ; ..####..
                        dc.b $06 ; 
                        dc.b $7e ; .######.
                        dc.b $08 ; 
                        dc.b $7e ; .######.
                        dc.b $09 ; 
                        dc.b $7e ; .######.
                        dc.b $0b ; 
                        dc.b $7e ; .######.
                        dc.b $0c ; 
                        dc.b $7e ; .######.
                        dc.b $0e ; 
                        dc.b $7e ; .######.
                        dc.b $0f ; 
                        dc.b $7e ; .######.
                        dc.b $11 ; 
                        dc.b $7e ; .######.
                        dc.b $12 ; 
                        dc.b $3c ; ..####..
                        dc.b $14 ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_04      equ  *
SpriteData_Plane_39     dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $00 ; 
                        dc.b $1c ; ...###..
                        dc.b $02 ; 
                        dc.b $38 ; ..###...
                        dc.b $03 ; 
                        dc.b $3e ; ..#####.
                        dc.b $05 ; 
                        dc.b $7c ; .#####..
                        dc.b $06 ; 
                        dc.b $3e ; ..#####.
                        dc.b $08 ; 
                        dc.b $7c ; .#####..
                        dc.b $09 ; 
                        dc.b $3e ; ..#####.
                        dc.b $0b ; 
                        dc.b $7c ; .#####..
                        dc.b $0c ; 
                        dc.b $3e ; ..#####.
                        dc.b $0e ; 
                        dc.b $7c ; .#####..
                        dc.b $0f ; 
                        dc.b $1c ; ...###..
                        dc.b $11 ; 
                        dc.b $38 ; ..###...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_05      equ  *
SpriteData_Plane_40     dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $00 ; 
                        dc.b $0e ; ....###.
                        dc.b $02 ; 
                        dc.b $70 ; .###....
                        dc.b $03 ; 
                        dc.b $1f ; ...#####
                        dc.b $05 ; 
                        dc.b $f8 ; #####...
                        dc.b $06 ; 
                        dc.b $1f ; ...#####
                        dc.b $08 ; 
                        dc.b $f8 ; #####...
                        dc.b $09 ; 
                        dc.b $1f ; ...#####
                        dc.b $0b ; 
                        dc.b $f8 ; #####...
                        dc.b $0c ; 
                        dc.b $0e ; ....###.
                        dc.b $0e ; 
                        dc.b $70 ; .###....
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_06      equ  *
SpriteData_Plane_41     dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $00 ; 
                        dc.b $07 ; .....###
                        dc.b $02 ; 
                        dc.b $e0 ; ###.....
                        dc.b $03 ; 
                        dc.b $0f ; ....####
                        dc.b $04 ; 
                        dc.b $81 ; #......#
                        dc.b $05 ; 
                        dc.b $f0 ; ####....
                        dc.b $06 ; 
                        dc.b $0f ; ....####
                        dc.b $07 ; 
                        dc.b $81 ; #......#
                        dc.b $08 ; 
                        dc.b $f0 ; ####....
                        dc.b $09 ; 
                        dc.b $07 ; .....###
                        dc.b $0b ; 
                        dc.b $e0 ; ###.....
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_07      equ  *
SpriteData_Plane_42     dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $00 ; 
                        dc.b $03 ; ......##
                        dc.b $02 ; 
                        dc.b $c0 ; ##......
                        dc.b $03 ; 
                        dc.b $07 ; .....###
                        dc.b $04 ; 
                        dc.b $81 ; #......#
                        dc.b $05 ; 
                        dc.b $e0 ; ###.....
                        dc.b $06 ; 
                        dc.b $07 ; .....###
                        dc.b $07 ; 
                        dc.b $81 ; #......#
                        dc.b $08 ; 
                        dc.b $e0 ; ###.....
                        dc.b $09 ; 
                        dc.b $03 ; ......##
                        dc.b $0b ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_08      equ  *
SpriteData_Plane_43     dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $00 ; 
                        dc.b $03 ; ......##
                        dc.b $01 ; 
                        dc.b $81 ; #......#
                        dc.b $02 ; 
                        dc.b $c0 ; ##......
                        dc.b $03 ; 
                        dc.b $03 ; ......##
                        dc.b $04 ; 
                        dc.b $81 ; #......#
                        dc.b $05 ; 
                        dc.b $c0 ; ##......
                        dc.b $06 ; 
                        dc.b $03 ; ......##
                        dc.b $07 ; 
                        dc.b $81 ; #......#
                        dc.b $08 ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_09      equ  *
SpriteData_Plane_44     dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $00 ; 
                        dc.b $01 ; .......#
                        dc.b $01 ; 
                        dc.b $c3 ; ##....##
                        dc.b $02 ; 
                        dc.b $80 ; #.......
                        dc.b $03 ; 
                        dc.b $01 ; .......#
                        dc.b $04 ; 
                        dc.b $c3 ; ##....##
                        dc.b $05 ; 
                        dc.b $80 ; #.......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_10      equ  *
SpriteData_Plane_45     dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $01 ; 
                        dc.b $c3 ; ##....##
                        dc.b $04 ; 
                        dc.b $c3 ; ##....##
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_11      equ  *
SpriteData_Plane_46     dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $01 ; 
                        dc.b $66 ; .##..##.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_12      equ  *
SpriteData_Plane_47     dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $01 ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_13      equ  *
SpriteData_Plane_48     dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $01 ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_14      equ  *
SpriteData_Plane_49     dc.b $00 ; <flag: full sprite data>
                                                
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $b4, $00, $2d ; #.##.#............#.##.#
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        
SpriteData_Ship_15      equ  *
SpriteData_Plane_50     dc.b $00 ; <flag: full sprite data>
                                                
                        dc.b $00, $00, $00 ; ........................
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $b4, $00, $2d ; #.##.#............#.##.#
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        
SpriteData_Ship_16      equ  *
SpriteData_Plane_51     dc.b $00 ; <flag: full sprite data>
                        
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $b4, $00, $2d ; #.##.#............#.##.#
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        
SpriteData_Ship_17      equ  *
SpriteData_Plane_52     dc.b $00 ; <flag: full sprite data>
                                                
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $b4, $00, $2d ; #.##.#............#.##.#
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        
SpriteData_Ship_18      equ  *
SpriteData_Plane_53     dc.b $00 ; <flag: full sprite data>
                                                
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $b4, $00, $2d ; #.##.#............#.##.#
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        
SpriteData_Ship_19      equ  *
SpriteData_Plane_54     dc.b $00 ; <flag: full sprite data>
                                                
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $b4, $00, $2d ; #.##.#............#.##.#
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        
SpriteData_Ship_20      equ  *
SpriteData_Plane_55     dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $12 ; 
                        dc.b $78 ; .####...
                        dc.b $14 ; 
                        dc.b $1e ; ...####.
                        dc.b $15 ; 
                        dc.b $fc ; ######..
                        dc.b $17 ; 
                        dc.b $3f ; ..######
                        dc.b $18 ; 
                        dc.b $fc ; ######..
                        dc.b $1a ; 
                        dc.b $3f ; ..######
                        dc.b $1b ; 
                        dc.b $fc ; ######..
                        dc.b $1d ; 
                        dc.b $3f ; ..######
                        dc.b $1e ; 
                        dc.b $fc ; ######..
                        dc.b $20 ; 
                        dc.b $3f ; ..######
                        dc.b $21 ; 
                        dc.b $fc ; ######..
                        dc.b $23 ; 
                        dc.b $3f ; ..######
                        dc.b $24 ; 
                        dc.b $b4 ; #.##.#..
                        dc.b $26 ; 
                        dc.b $2d ; ..#.##.#
                        dc.b $27 ; 
                        dc.b $78 ; .####...
                        dc.b $29 ; 
                        dc.b $1e ; ...####.
                        dc.b $2a ; 
                        dc.b $78 ; .####...
                        dc.b $2c ; 
                        dc.b $1e ; ...####.
                        dc.b $2d ; 
                        dc.b $78 ; .####...
                        dc.b $2f ; 
                        dc.b $1e ; ...####.
                        dc.b $30 ; 
                        dc.b $78 ; .####...
                        dc.b $32 ; 
                        dc.b $1e ; ...####.
                        dc.b $33 ; 
                        dc.b $78 ; .####...
                        dc.b $35 ; 
                        dc.b $1e ; ...####.
                        dc.b $36 ; 
                        dc.b $78 ; .####...
                        dc.b $38 ; 
                        dc.b $1e ; ...####.
                        dc.b $39 ; 
                        dc.b $78 ; .####...
                        dc.b $3b ; 
                        dc.b $1e ; ...####.
                        dc.b $3c ; 
                        dc.b $78 ; .####...
                        dc.b $3e ; 
                        dc.b $1e ; ...####.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_21      equ  *
SpriteData_Plane_56     dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $15 ; 
                        dc.b $78 ; .####...
                        dc.b $17 ; 
                        dc.b $1e ; ...####.
                        dc.b $18 ; 
                        dc.b $fc ; ######..
                        dc.b $1a ; 
                        dc.b $3f ; ..######
                        dc.b $1b ; 
                        dc.b $fc ; ######..
                        dc.b $1d ; 
                        dc.b $3f ; ..######
                        dc.b $1e ; 
                        dc.b $fc ; ######..
                        dc.b $20 ; 
                        dc.b $3f ; ..######
                        dc.b $21 ; 
                        dc.b $fc ; ######..
                        dc.b $23 ; 
                        dc.b $3f ; ..######
                        dc.b $24 ; 
                        dc.b $fc ; ######..
                        dc.b $26 ; 
                        dc.b $3f ; ..######
                        dc.b $27 ; 
                        dc.b $b4 ; #.##.#..
                        dc.b $29 ; 
                        dc.b $2d ; ..#.##.#
                        dc.b $2a ; 
                        dc.b $78 ; .####...
                        dc.b $2c ; 
                        dc.b $1e ; ...####.
                        dc.b $2d ; 
                        dc.b $78 ; .####...
                        dc.b $2f ; 
                        dc.b $1e ; ...####.
                        dc.b $30 ; 
                        dc.b $78 ; .####...
                        dc.b $32 ; 
                        dc.b $1e ; ...####.
                        dc.b $33 ; 
                        dc.b $78 ; .####...
                        dc.b $35 ; 
                        dc.b $1e ; ...####.
                        dc.b $36 ; 
                        dc.b $78 ; .####...
                        dc.b $38 ; 
                        dc.b $1e ; ...####.
                        dc.b $39 ; 
                        dc.b $78 ; .####...
                        dc.b $3b ; 
                        dc.b $1e ; ...####.
                        dc.b $3c ; 
                        dc.b $78 ; .####...
                        dc.b $3e ; 
                        dc.b $1e ; ...####.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_22      equ  *
SpriteData_Plane_57     dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $18 ; 
                        dc.b $78 ; .####...
                        dc.b $1a ; 
                        dc.b $1e ; ...####.
                        dc.b $1b ; 
                        dc.b $fc ; ######..
                        dc.b $1d ; 
                        dc.b $3f ; ..######
                        dc.b $1e ; 
                        dc.b $fc ; ######..
                        dc.b $20 ; 
                        dc.b $3f ; ..######
                        dc.b $21 ; 
                        dc.b $fc ; ######..
                        dc.b $23 ; 
                        dc.b $3f ; ..######
                        dc.b $24 ; 
                        dc.b $fc ; ######..
                        dc.b $26 ; 
                        dc.b $3f ; ..######
                        dc.b $27 ; 
                        dc.b $b4 ; #.##.#..
                        dc.b $29 ; 
                        dc.b $2d ; ..#.##.#
                        dc.b $2a ; 
                        dc.b $78 ; .####...
                        dc.b $2c ; 
                        dc.b $1e ; ...####.
                        dc.b $2d ; 
                        dc.b $78 ; .####...
                        dc.b $2f ; 
                        dc.b $1e ; ...####.
                        dc.b $30 ; 
                        dc.b $78 ; .####...
                        dc.b $32 ; 
                        dc.b $1e ; ...####.
                        dc.b $33 ; 
                        dc.b $78 ; .####...
                        dc.b $35 ; 
                        dc.b $1e ; ...####.
                        dc.b $36 ; 
                        dc.b $78 ; .####...
                        dc.b $38 ; 
                        dc.b $1e ; ...####.
                        dc.b $39 ; 
                        dc.b $78 ; .####...
                        dc.b $3b ; 
                        dc.b $1e ; ...####.
                        dc.b $3c ; 
                        dc.b $78 ; .####...
                        dc.b $3e ; 
                        dc.b $1e ; ...####.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_23     equ  *
SpriteData_Plane_58     dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $1b ; 
                        dc.b $78 ; .####...
                        dc.b $1d ; 
                        dc.b $1e ; ...####.
                        dc.b $1e ; 
                        dc.b $fc ; ######..
                        dc.b $20 ; 
                        dc.b $3f ; ..######
                        dc.b $21 ; 
                        dc.b $fc ; ######..
                        dc.b $23 ; 
                        dc.b $3f ; ..######
                        dc.b $24 ; 
                        dc.b $fc ; ######..
                        dc.b $26 ; 
                        dc.b $3f ; ..######
                        dc.b $27 ; 
                        dc.b $fc ; ######..
                        dc.b $29 ; 
                        dc.b $3f ; ..######
                        dc.b $2a ; 
                        dc.b $b4 ; #.##.#..
                        dc.b $2c ; 
                        dc.b $2d ; ..#.##.#
                        dc.b $2d ; 
                        dc.b $78 ; .####...
                        dc.b $2f ; 
                        dc.b $1e ; ...####.
                        dc.b $30 ; 
                        dc.b $78 ; .####...
                        dc.b $32 ; 
                        dc.b $1e ; ...####.
                        dc.b $33 ; 
                        dc.b $78 ; .####...
                        dc.b $35 ; 
                        dc.b $1e ; ...####.
                        dc.b $36 ; 
                        dc.b $78 ; .####...
                        dc.b $38 ; 
                        dc.b $1e ; ...####.
                        dc.b $39 ; 
                        dc.b $78 ; .####...
                        dc.b $3b ; 
                        dc.b $1e ; ...####.
                        dc.b $3c ; 
                        dc.b $78 ; .####...
                        dc.b $3e ; 
                        dc.b $1e ; ...####.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_24      equ  *
SpriteData_Plane_59     dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $1e ; 
                        dc.b $78 ; .####...
                        dc.b $20 ; 
                        dc.b $1e ; ...####.
                        dc.b $21 ; 
                        dc.b $fc ; ######..
                        dc.b $23 ; 
                        dc.b $3f ; ..######
                        dc.b $24 ; 
                        dc.b $fc ; ######..
                        dc.b $26 ; 
                        dc.b $3f ; ..######
                        dc.b $27 ; 
                        dc.b $fc ; ######..
                        dc.b $29 ; 
                        dc.b $3f ; ..######
                        dc.b $2a ; 
                        dc.b $b4 ; #.##.#..
                        dc.b $2c ; 
                        dc.b $2d ; ..#.##.#
                        dc.b $2d ; 
                        dc.b $78 ; .####...
                        dc.b $2f ; 
                        dc.b $1e ; ...####.
                        dc.b $30 ; 
                        dc.b $78 ; .####...
                        dc.b $32 ; 
                        dc.b $1e ; ...####.
                        dc.b $33 ; 
                        dc.b $78 ; .####...
                        dc.b $35 ; 
                        dc.b $1e ; ...####.
                        dc.b $36 ; 
                        dc.b $78 ; .####...
                        dc.b $38 ; 
                        dc.b $1e ; ...####.
                        dc.b $39 ; 
                        dc.b $78 ; .####...
                        dc.b $3b ; 
                        dc.b $1e ; ...####.
                        dc.b $3c ; 
                        dc.b $78 ; .####...
                        dc.b $3e ; 
                        dc.b $1e ; ...####.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_25      equ  *
SpriteData_Plane_60     dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $21 ; 
                        dc.b $78 ; .####...
                        dc.b $23 ; 
                        dc.b $1e ; ...####.
                        dc.b $24 ; 
                        dc.b $fc ; ######..
                        dc.b $26 ; 
                        dc.b $3f ; ..######
                        dc.b $27 ; 
                        dc.b $fc ; ######..
                        dc.b $29 ; 
                        dc.b $3f ; ..######
                        dc.b $2a ; 
                        dc.b $fc ; ######..
                        dc.b $2c ; 
                        dc.b $3f ; ..######
                        dc.b $2d ; 
                        dc.b $b4 ; #.##.#..
                        dc.b $2f ; 
                        dc.b $2d ; ..#.##.#
                        dc.b $30 ; 
                        dc.b $78 ; .####...
                        dc.b $32 ; 
                        dc.b $1e ; ...####.
                        dc.b $33 ; 
                        dc.b $78 ; .####...
                        dc.b $35 ; 
                        dc.b $1e ; ...####.
                        dc.b $36 ; 
                        dc.b $78 ; .####...
                        dc.b $38 ; 
                        dc.b $1e ; ...####.
                        dc.b $39 ; 
                        dc.b $78 ; .####...
                        dc.b $3b ; 
                        dc.b $1e ; ...####.
                        dc.b $3c ; 
                        dc.b $78 ; .####...
                        dc.b $3e ; 
                        dc.b $1e ; ...####.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_26      equ  *
SpriteData_Plane_61     dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $24 ; 
                        dc.b $78 ; .####...
                        dc.b $26 ; 
                        dc.b $1e ; ...####.
                        dc.b $27 ; 
                        dc.b $fc ; ######..
                        dc.b $29 ; 
                        dc.b $3f ; ..######
                        dc.b $2a ; 
                        dc.b $fc ; ######..
                        dc.b $2c ; 
                        dc.b $3f ; ..######
                        dc.b $2d ; 
                        dc.b $b4 ; #.##.#..
                        dc.b $2f ; 
                        dc.b $2d ; ..#.##.#
                        dc.b $30 ; 
                        dc.b $78 ; .####...
                        dc.b $32 ; 
                        dc.b $1e ; ...####.
                        dc.b $33 ; 
                        dc.b $78 ; .####...
                        dc.b $35 ; 
                        dc.b $1e ; ...####.
                        dc.b $36 ; 
                        dc.b $78 ; .####...
                        dc.b $38 ; 
                        dc.b $1e ; ...####.
                        dc.b $39 ; 
                        dc.b $78 ; .####...
                        dc.b $3b ; 
                        dc.b $1e ; ...####.
                        dc.b $3c ; 
                        dc.b $78 ; .####...
                        dc.b $3e ; 
                        dc.b $1e ; ...####.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_27      equ  *
SpriteData_Plane_62     dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $27 ; 
                        dc.b $78 ; .####...
                        dc.b $29 ; 
                        dc.b $1e ; ...####.
                        dc.b $2a ; 
                        dc.b $fc ; ######..
                        dc.b $2c ; 
                        dc.b $3f ; ..######
                        dc.b $2d ; 
                        dc.b $fc ; ######..
                        dc.b $2f ; 
                        dc.b $3f ; ..######
                        dc.b $30 ; 
                        dc.b $b4 ; #.##.#..
                        dc.b $32 ; 
                        dc.b $2d ; ..#.##.#
                        dc.b $33 ; 
                        dc.b $78 ; .####...
                        dc.b $35 ; 
                        dc.b $1e ; ...####.
                        dc.b $36 ; 
                        dc.b $78 ; .####...
                        dc.b $38 ; 
                        dc.b $1e ; ...####.
                        dc.b $39 ; 
                        dc.b $78 ; .####...
                        dc.b $3b ; 
                        dc.b $1e ; ...####.
                        dc.b $3c ; 
                        dc.b $78 ; .####...
                        dc.b $3e ; 
                        dc.b $1e ; ...####.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_28      equ  *
SpriteData_Plane_63     dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $2a ; 
                        dc.b $78 ; .####...
                        dc.b $2c ; 
                        dc.b $1e ; ...####.
                        dc.b $2d ; 
                        dc.b $fc ; ######..
                        dc.b $2f ; 
                        dc.b $3f ; ..######
                        dc.b $30 ; 
                        dc.b $b4 ; #.##.#..
                        dc.b $32 ; 
                        dc.b $2d ; ..#.##.#
                        dc.b $33 ; 
                        dc.b $78 ; .####...
                        dc.b $35 ; 
                        dc.b $1e ; ...####.
                        dc.b $36 ; 
                        dc.b $78 ; .####...
                        dc.b $38 ; 
                        dc.b $1e ; ...####.
                        dc.b $39 ; 
                        dc.b $78 ; .####...
                        dc.b $3b ; 
                        dc.b $1e ; ...####.
                        dc.b $3c ; 
                        dc.b $78 ; .####...
                        dc.b $3e ; 
                        dc.b $1e ; ...####.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_29      equ  *
SpriteData_Plane_64     dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $2d ; 
                        dc.b $78 ; .####...
                        dc.b $2f ; 
                        dc.b $1e ; ...####.
                        dc.b $30 ; 
                        dc.b $fc ; ######..
                        dc.b $32 ; 
                        dc.b $3f ; ..######
                        dc.b $33 ; 
                        dc.b $b4 ; #.##.#..
                        dc.b $35 ; 
                        dc.b $2d ; ..#.##.#
                        dc.b $36 ; 
                        dc.b $78 ; .####...
                        dc.b $38 ; 
                        dc.b $1e ; ...####.
                        dc.b $39 ; 
                        dc.b $78 ; .####...
                        dc.b $3b ; 
                        dc.b $1e ; ...####.
                        dc.b $3c ; 
                        dc.b $78 ; .####...
                        dc.b $3e ; 
                        dc.b $1e ; ...####.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_30      equ  *
SpriteData_Hill_79      equ  *
SpriteData_Plane_65     dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $1f ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_31      equ  *
SpriteData_Hill_80      equ  *
SpriteData_Plane_66     dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $1f ; 
                        dc.b $18 ; ...##...
                        dc.b $22 ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_32      equ  *
SpriteData_Hill_81      equ  *
SpriteData_Plane_67     dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $1f ; 
                        dc.b $18 ; ...##...
                        dc.b $22 ; 
                        dc.b $3c ; ..####..
                        dc.b $25 ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_33      equ  *
SpriteData_Hill_82      equ  *
SpriteData_Plane_68     dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $22 ; 
                        dc.b $18 ; ...##...
                        dc.b $25 ; 
                        dc.b $3c ; ..####..
                        dc.b $28 ; 
                        dc.b $3c ; ..####..
                        dc.b $2b ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_34      equ  *
SpriteData_Hill_83      equ  *
SpriteData_Plane_69     dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $22 ; 
                        dc.b $18 ; ...##...
                        dc.b $25 ; 
                        dc.b $3c ; ..####..
                        dc.b $28 ; 
                        dc.b $7e ; .######.
                        dc.b $2b ; 
                        dc.b $3c ; ..####..
                        dc.b $2e ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_35      equ  *
SpriteData_Hill_84      equ  *
SpriteData_Plane_70     dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $25 ; 
                        dc.b $18 ; ...##...
                        dc.b $28 ; 
                        dc.b $3c ; ..####..
                        dc.b $2b ; 
                        dc.b $7e ; .######.
                        dc.b $2e ; 
                        dc.b $7e ; .######.
                        dc.b $31 ; 
                        dc.b $3c ; ..####..
                        dc.b $34 ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_85      equ  *
SpriteData_Plane_71     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $28 ; 
                        dc.b $18 ; ...##...
                        dc.b $2b ; 
                        dc.b $3c ; ..####..
                        dc.b $2e ; 
                        dc.b $7e ; .######.
                        dc.b $31 ; 
                        dc.b $7e ; .######.
                        dc.b $34 ; 
                        dc.b $7e ; .######.
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_86      equ  *
SpriteData_Plane_72     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $28 ; 
                        dc.b $18 ; ...##...
                        dc.b $2b ; 
                        dc.b $3c ; ..####..
                        dc.b $2e ; 
                        dc.b $7e ; .######.
                        dc.b $31 ; 
                        dc.b $7e ; .######.
                        dc.b $34 ; 
                        dc.b $7e ; .######.
                        dc.b $37 ; 
                        dc.b $7e ; .######.
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_73     dc.b $00 ; <flag: full sprite data>
                        
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $08, $08, $00 ; ....#.......#...........
                        dc.b $06, $36, $00 ; .....##...##.##.........
                        dc.b $03, $6b, $40 ; ......##.##.#.##.#......
                        dc.b $0a, $ed, $b0 ; ....#.#.###.##.##.##....
                        dc.b $1a, $aa, $98 ; ...##.#.#.#.#.#.#..##...
                        dc.b $0d, $9a, $60 ; ....##.##..##.#..##.....
                        dc.b $3a, $eb, $80 ; ..###.#.###.#.###.......
                        dc.b $aa, $a6, $90 ; #.#.#.#.#.#..##.#..#....
                        dc.b $76, $6e, $b4 ; .###.##..##.###.#.##.#..
                        dc.b $2b, $aa, $68 ; ..#.#.###.#.#.#..##.#...
                        dc.b $06, $96, $ae ; .....##.#..#.##.#.#.###.
                        dc.b $03, $ae, $99 ; ......###.#.###.#..##..#
                        dc.b $09, $a9, $b8 ; ....#..##.#.#..##.###...
                        dc.b $03, $4a, $a4 ; ......##.#..#.#.#.#..#..
                        dc.b $00, $01, $e0 ; ...............####.....
                        dc.b $00, $00, $90 ; ................#..#....
                        dc.b $00, $00, $80 ; ................#.......
                        
SpriteData_Plane_74     dc.b $00 ; <flag: full sprite data>
                        
                        dc.b $00, $90, $00 ; ........#..#............
                        dc.b $00, $22, $02 ; ..........#...#.......#.
                        dc.b $00, $e9, $c1 ; ........###.#..###.....#
                        dc.b $00, $00, $93 ; ................#..#..##
                        dc.b $00, $28, $76 ; ..........#.#....###.##.
                        dc.b $08, $36, $ae ; ....#.....##.##.#.#.###.
                        dc.b $06, $0b, $a9 ; .....##.....#.###.#.#..#
                        dc.b $3a, $86, $9a ; ..###.#.#....##.#..##.#.
                        dc.b $01, $a9, $ae ; .......##.#.#..##.#.###.
                        dc.b $22, $ba, $69 ; ..#...#.#.###.#..##.#..#
                        dc.b $9a, $66, $b6 ; #..##.#..##..##.#.##.##.
                        dc.b $27, $aa, $aa ; ..#..####.#.#.#.#.#.#.#.
                        dc.b $08, $0b, $9b ; ....#.......#.###..##.##
                        dc.b $00, $89, $a9 ; ........#...#..##.#.#..#
                        dc.b $00, $26, $ba ; ..........#..##.#.###.#.
                        dc.b $00, $aa, $6a ; ........#.#.#.#..##.#.#.
                        dc.b $00, $9e, $a7 ; ........#..####.#.#..###
                        dc.b $00, $c1, $3a ; ........##.....#..###.#.
                        dc.b $02, $48, $19 ; ......#..#..#......##..#
                        dc.b $03, $04, $08 ; ......##.....#......#...
                        dc.b $00, $00, $00 ; ........................
                        
SpriteData_Plane_75     dc.b $00 ; <flag: full sprite data>
                        
                        dc.b $0c, $00, $00 ; ....##..................
                        dc.b $98, $08, $00 ; #..##.......#...........
                        dc.b $e0, $36, $00 ; ###.......##.##.........
                        dc.b $60, $10, $00 ; .##........#............
                        dc.b $b3, $a0, $70 ; #.##..###.#......###....
                        dc.b $9a, $a2, $80 ; #..##.#.#.#...#.#.......
                        dc.b $ee, $62, $c0 ; ###.###..##...#.##......
                        dc.b $aa, $ad, $80 ; #.#.#.#.#.#.##.##.......
                        dc.b $a6, $ea, $8a ; #.#..##.###.#.#.#...#.#.
                        dc.b $7a, $9a, $ec ; .####.#.#..##.#.###.##..
                        dc.b $a9, $ab, $64 ; #.#.#..##.#.#.##.##..#..
                        dc.b $9b, $a6, $a9 ; #..##.###.#..##.#.#.#..#
                        dc.b $ea, $7a, $9e ; ###.#.#..####.#.#..####.
                        dc.b $aa, $a8, $28 ; #.#.#.#.#.#.#.....#.#...
                        dc.b $86, $98, $04 ; #....##.#..##........#..
                        dc.b $4e, $ae, $00 ; .#..###.#.#.###.........
                        dc.b $81, $3a, $80 ; #......#..###.#.#.......
                        dc.b $92, $86, $c0 ; #..#..#.#....##.##......
                        dc.b $b3, $81, $80 ; #.##..###......##.......
                        dc.b $e2, $60, $80 ; ###...#..##.....#.......
                        dc.b $01, $00, $00 ; .......#................
; -------------------------------------------------------------------------------------------------------------- ;
SpriteData_Cave_01      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $13 ; 
                        dc.b $38 ; ..###...
                        dc.b $16 ; 
                        dc.b $38 ; ..###...
                        dc.b $19 ; 
                        dc.b $38 ; ..###...
                        dc.b $1c ; 
                        dc.b $38 ; ..###...
                        dc.b $1f ; 
                        dc.b $38 ; ..###...
                        dc.b $22 ; 
                        dc.b $38 ; ..###...
                        dc.b $25 ; 
                        dc.b $38 ; ..###...
                        dc.b $28 ; 
                        dc.b $38 ; ..###...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Cave_02      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $13 ; 
                        dc.b $0e ; ....###.
                        dc.b $16 ; 
                        dc.b $0e ; ....###.
                        dc.b $19 ; 
                        dc.b $1c ; ...###..
                        dc.b $1c ; 
                        dc.b $1c ; ...###..
                        dc.b $1f ; 
                        dc.b $38 ; ..###...
                        dc.b $22 ; 
                        dc.b $38 ; ..###...
                        dc.b $25 ; 
                        dc.b $70 ; .###....
                        dc.b $28 ; 
                        dc.b $70 ; .###....
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Cave_03      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $13 ; 
                        dc.b $03 ; ......##
                        dc.b $16 ; 
                        dc.b $07 ; .....###
                        dc.b $19 ; 
                        dc.b $0e ; ....###.
                        dc.b $1c ; 
                        dc.b $1c ; ...###..
                        dc.b $1f ; 
                        dc.b $38 ; ..###...
                        dc.b $22 ; 
                        dc.b $70 ; .###....
                        dc.b $25 ; 
                        dc.b $e0 ; ###.....
                        dc.b $28 ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Cave_04      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $16 ; 
                        dc.b $01 ; .......#
                        dc.b $17 ; 
                        dc.b $c0 ; ##......
                        dc.b $19 ; 
                        dc.b $07 ; .....###
                        dc.b $1a ; 
                        dc.b $c0 ; ##......
                        dc.b $1c ; 
                        dc.b $1f ; ...#####
                        dc.b $1f ; 
                        dc.b $7c ; .#####..
                        dc.b $21 ; 
                        dc.b $01 ; .......#
                        dc.b $22 ; 
                        dc.b $f0 ; ####....
                        dc.b $24 ; 
                        dc.b $01 ; .......#
                        dc.b $25 ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Cave_05      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1b ; 
                        dc.b $03 ; ......##
                        dc.b $1c ; 
                        dc.b $ff ; ########
                        dc.b $1d ; 
                        dc.b $c0 ; ##......
                        dc.b $1e ; 
                        dc.b $03 ; ......##
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Cave_06      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $15 ; 
                        dc.b $01 ; .......#
                        dc.b $16 ; 
                        dc.b $c0 ; ##......
                        dc.b $18 ; 
                        dc.b $01 ; .......#
                        dc.b $19 ; 
                        dc.b $f0 ; ####....
                        dc.b $1c ; 
                        dc.b $7c ; .#####..
                        dc.b $1f ; 
                        dc.b $1f ; ...#####
                        dc.b $22 ; 
                        dc.b $07 ; .....###
                        dc.b $23 ; 
                        dc.b $c0 ; ##......
                        dc.b $25 ; 
                        dc.b $01 ; .......#
                        dc.b $26 ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Cave_07      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $13 ; 
                        dc.b $c0 ; ##......
                        dc.b $16 ; 
                        dc.b $e0 ; ###.....
                        dc.b $19 ; 
                        dc.b $70 ; .###....
                        dc.b $1c ; 
                        dc.b $38 ; ..###...
                        dc.b $1f ; 
                        dc.b $1c ; ...###..
                        dc.b $22 ; 
                        dc.b $0e ; ....###.
                        dc.b $25 ; 
                        dc.b $07 ; .....###
                        dc.b $28 ; 
                        dc.b $03 ; ......##
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Cave_08      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $13 ; 
                        dc.b $70 ; .###....
                        dc.b $16 ; 
                        dc.b $70 ; .###....
                        dc.b $19 ; 
                        dc.b $38 ; ..###...
                        dc.b $1c ; 
                        dc.b $38 ; ..###...
                        dc.b $1f ; 
                        dc.b $1c ; ...###..
                        dc.b $22 ; 
                        dc.b $1c ; ...###..
                        dc.b $25 ; 
                        dc.b $0e ; ....###.
                        dc.b $28 ; 
                        dc.b $0e ; ....###.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Cave_09      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $13 ; 
                        dc.b $60 ; .##.....
                        dc.b $16 ; 
                        dc.b $e6 ; ###..##.
                        dc.b $18 ; 
                        dc.b $03 ; ......##
                        dc.b $19 ; 
                        dc.b $ee ; ###.###.
                        dc.b $1b ; 
                        dc.b $fe ; #######.
                        dc.b $1c ; 
                        dc.b $12 ; ...#..#.
                        dc.b $1d ; 
                        dc.b $c0 ; ##......
                        dc.b $1e ; 
                        dc.b $7f ; .#######
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $ff ; ########
                        dc.b $21 ; 
                        dc.b $3f ; ..######
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $23 ; 
                        dc.b $ff ; ########
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Cave_10      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0c ; ....##..
                        dc.b $38 ; 
                        dc.b $0d ; ....##.#
                        dc.b $60 ; 
                        dc.b $0f ; ....####
                        dc.b $3e ; 
                        dc.b $10 ; ...#....
                        dc.b $e0 ; 
                        dc.b $12 ; ...#..#.
                        dc.b $3e ; 
                        dc.b $13 ; ...#..##
                        dc.b $e0 ; 
                        dc.b $15 ; ...#.#.#
                        dc.b $1f ; 
                        dc.b $16 ; ...#.##.
                        dc.b $76 ; 
                        dc.b $18 ; ...##...
                        dc.b $0f ; 
                        dc.b $19 ; ...##..#
                        dc.b $b6 ; 
                        dc.b $1b ; ...##.##
                        dc.b $07 ; 
                        dc.b $1c ; ...###..
                        dc.b $e6 ; 
                        dc.b $1e ; ...####.
                        dc.b $01 ; 
                        dc.b $1f ; ...#####
                        dc.b $fa ; 
                        dc.b $22 ; ..#...#.
                        dc.b $7f ; 
                        dc.b $23 ; ..#...##
                        dc.b $80 ; 
                        dc.b $25 ; ..#..#.#
                        dc.b $1f ; 
                        dc.b $26 ; ..#..##.
                        dc.b $e0 ; 
                        dc.b $28 ; ..#.#...
                        dc.b $03 ; 
                        dc.b $29 ; ..#.#..#
                        dc.b $f8 ; 
                        dc.b $2c ; ..#.##..
                        dc.b $78 ; 
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Cave_11      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $09 ; 
                        dc.b $07 ; .....###
                        dc.b $0c ; 
                        dc.b $07 ; .....###
                        dc.b $0d ; 
                        dc.b $60 ; .##.....
                        dc.b $0f ; 
                        dc.b $06 ; .....##.
                        dc.b $10 ; 
                        dc.b $e0 ; ###.....
                        dc.b $12 ; 
                        dc.b $06 ; .....##.
                        dc.b $13 ; 
                        dc.b $e0 ; ###.....
                        dc.b $15 ; 
                        dc.b $03 ; ......##
                        dc.b $16 ; 
                        dc.b $6c ; .##.##..
                        dc.b $18 ; 
                        dc.b $03 ; ......##
                        dc.b $19 ; 
                        dc.b $ac ; #.#.##..
                        dc.b $1b ; 
                        dc.b $01 ; .......#
                        dc.b $1c ; 
                        dc.b $fc ; ######..
                        dc.b $1f ; 
                        dc.b $ec ; ###.##..
                        dc.b $22 ; 
                        dc.b $75 ; .###.#.#
                        dc.b $25 ; 
                        dc.b $3f ; ..######
                        dc.b $26 ; 
                        dc.b $80 ; #.......
                        dc.b $28 ; 
                        dc.b $1f ; ...#####
                        dc.b $29 ; 
                        dc.b $c0 ; ##......
                        dc.b $2b ; 
                        dc.b $0f ; ....####
                        dc.b $2c ; 
                        dc.b $c0 ; ##......
                        dc.b $2e ; 
                        dc.b $03 ; ......##
                        dc.b $2f ; 
                        dc.b $e0 ; ###.....
                        dc.b $32 ; 
                        dc.b $e0 ; ###.....
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Cave_12      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0a ; 
                        dc.b $c0 ; ##......
                        dc.b $0c ; 
                        dc.b $01 ; .......#
                        dc.b $0d ; 
                        dc.b $b0 ; #.##....
                        dc.b $0f ; 
                        dc.b $01 ; .......#
                        dc.b $10 ; 
                        dc.b $b0 ; #.##....
                        dc.b $12 ; 
                        dc.b $01 ; .......#
                        dc.b $13 ; 
                        dc.b $b0 ; #.##....
                        dc.b $16 ; 
                        dc.b $cc ; ##..##..
                        dc.b $19 ; 
                        dc.b $ec ; ###.##..
                        dc.b $1c ; 
                        dc.b $6c ; .##.##..
                        dc.b $1f ; 
                        dc.b $65 ; .##..#.#
                        dc.b $22 ; 
                        dc.b $3b ; ..###.##
                        dc.b $25 ; 
                        dc.b $1f ; ...#####
                        dc.b $28 ; 
                        dc.b $0f ; ....####
                        dc.b $29 ; 
                        dc.b $80 ; #.......
                        dc.b $2b ; 
                        dc.b $07 ; .....###
                        dc.b $2c ; 
                        dc.b $80 ; #.......
                        dc.b $2e ; 
                        dc.b $03 ; ......##
                        dc.b $2f ; 
                        dc.b $c0 ; ##......
                        dc.b $31 ; 
                        dc.b $01 ; .......#
                        dc.b $32 ; 
                        dc.b $80 ; #.......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Cave_13      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0a ; 
                        dc.b $18 ; ...##...
                        dc.b $0d ; 
                        dc.b $18 ; ...##...
                        dc.b $10 ; 
                        dc.b $66 ; .##..##.
                        dc.b $13 ; 
                        dc.b $5a ; .#.##.#.
                        dc.b $16 ; 
                        dc.b $db ; ##.##.##
                        dc.b $19 ; 
                        dc.b $db ; ##.##.##
                        dc.b $1c ; 
                        dc.b $e7 ; ###..###
                        dc.b $1f ; 
                        dc.b $bd ; #.####.#
                        dc.b $22 ; 
                        dc.b $e7 ; ###..###
                        dc.b $25 ; 
                        dc.b $ff ; ########
                        dc.b $28 ; 
                        dc.b $7e ; .######.
                        dc.b $2b ; 
                        dc.b $7e ; .######.
                        dc.b $2e ; 
                        dc.b $3c ; ..####..
                        dc.b $31 ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Tank_01      equ  *
SpriteData_Ship_36      equ  *
SpriteData_Cave_14      dc.b $00 ; <flag: full sprite data>
                                                
                        dc.b $00, $30, $00 ; ..........##............
                        dc.b $00, $70, $00 ; .........###............
                        dc.b $00, $78, $38 ; .........####.....###...
                        dc.b $33, $9c, $f8 ; ..##..###..###..#####...
                        dc.b $7f, $ff, $f0 ; .###################....
                        dc.b $33, $f7, $a0 ; ..##..######.####.#.....
                        dc.b $1e, $fc, $e0 ; ...####.######..###.....
                        dc.b $3f, $9f, $fc ; ..#######..###########..
                        dc.b $7f, $f9, $be ; .############..##.#####.
                        dc.b $f9, $ff, $f8 ; #####..##############...
                        dc.b $df, $fe, $e0 ; ##.############.###.....
                        dc.b $3f, $cf, $f0 ; ..########..########....
                        dc.b $13, $ff, $f8 ; ...#..###############...
                        dc.b $1f, $fe, $78 ; ...############..####...
                        dc.b $3f, $9f, $c0 ; ..#######..#######......
                        dc.b $7b, $ff, $e0 ; .####.#############.....
                        dc.b $4b, $f4, $e0 ; .#..#.######.#..###.....
                        dc.b $03, $43, $b0 ; ......##.#....###.##....
                        dc.b $07, $c0, $f0 ; .....#####......####....
                        dc.b $01, $80, $30 ; .......##.........##....
                        dc.b $00, $00, $00 ; ........................
                        
SpriteData_Cave_15      dc.b $00 ; <flag: full sprite data>
                        
                        dc.b $00, $30, $00 ; ..........##............
                        dc.b $00, $40, $00 ; .........#..............
                        dc.b $00, $68, $18 ; .........##.#......##...
                        dc.b $33, $84, $48 ; ..##..###....#...#..#...
                        dc.b $6c, $6b, $70 ; .##.##...##.#.##.###....
                        dc.b $13, $25, $20 ; ...#..##..#..#.#..#.....
                        dc.b $0a, $68, $80 ; ....#.#..##.#...#.......
                        dc.b $31, $1a, $d4 ; ..##...#...##.#.##.#.#..
                        dc.b $4e, $61, $2c ; .#..###..##....#..#.##..
                        dc.b $58, $95, $d8 ; .#.##...#..#.#.###.##...
                        dc.b $82, $a2, $a0 ; #.....#.#.#...#.#.#.....
                        dc.b $2d, $4d, $30 ; ..#.##.#.#..##.#..##....
                        dc.b $11, $24, $d8 ; ...#...#..#..#..##.##...
                        dc.b $0e, $b2, $68 ; ....###.#.##..#..##.#...
                        dc.b $29, $1b, $40 ; ..#.#..#...##.##.#......
                        dc.b $73, $69, $a0 ; .###..##.##.#..##.#.....
                        dc.b $08, $14, $e0 ; ....#......#.#..###.....
                        dc.b $02, $42, $b0 ; ......#..#....#.#.##....
                        dc.b $06, $80, $c0 ; .....##.#.......##......
                        dc.b $01, $00, $30 ; .......#..........##....
                        dc.b $00, $00, $00 ; ........................
                        
SpriteData_Cave_16      dc.b $00 ; <flag: full sprite data>
                        
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $40, $10 ; .........#.........#....
                        dc.b $30, $84, $08 ; ..##....#....#......#...
                        dc.b $0c, $43, $40 ; ....##...#....##.#......
                        dc.b $02, $00, $20 ; ......#...........#.....
                        dc.b $02, $28, $00 ; ......#...#.#...........
                        dc.b $20, $1a, $44 ; ..#........##.#..#...#..
                        dc.b $08, $41, $0c ; ....#....#.....#....##..
                        dc.b $18, $81, $80 ; ...##...#......##.......
                        dc.b $02, $02, $00 ; ......#.......#.........
                        dc.b $05, $08, $20 ; .....#.#....#.....#.....
                        dc.b $01, $04, $c0 ; .......#.....#..##......
                        dc.b $04, $82, $48 ; .....#..#.....#..#..#...
                        dc.b $28, $03, $00 ; ..#.#.........##........
                        dc.b $50, $61, $00 ; .#.#.....##....#........
                        dc.b $00, $10, $40 ; ...........#.....#......
                        dc.b $02, $00, $a0 ; ......#.........#.#.....
                        dc.b $06, $00, $00 ; .....##.................
                        dc.b $00, $00, $30 ; ..................##....
                        dc.b $00, $00, $00 ; ........................
; -------------------------------------------------------------------------------------------------------------- ;
SpriteData_Ship_37      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ; 
                        dc.b $18 ; ...##...
                        dc.b $1c ; 
                        dc.b $18 ; ...##...
                        dc.b $1f ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_38      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $10 ; 
                        dc.b $18 ; ...##...
                        dc.b $13 ; 
                        dc.b $3c ; ..####..
                        dc.b $16 ; 
                        dc.b $3c ; ..####..
                        dc.b $19 ; 
                        dc.b $3c ; ..####..
                        dc.b $1c ; 
                        dc.b $18 ; ...##...
                        dc.b $1f ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_39      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $07 ; 
                        dc.b $3c ; ..####..
                        dc.b $0a ; 
                        dc.b $7e ; .######.
                        dc.b $0d ; 
                        dc.b $7e ; .######.
                        dc.b $10 ; 
                        dc.b $7e ; .######.
                        dc.b $13 ; 
                        dc.b $7e ; .######.
                        dc.b $16 ; 
                        dc.b $3c ; ..####..
                        dc.b $19 ; 
                        dc.b $3c ; ..####..
                        dc.b $1c ; 
                        dc.b $18 ; ...##...
                        dc.b $1f ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_40      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $22 ; 
                        dc.b $18 ; ...##...
                        dc.b $25 ; 
                        dc.b $38 ; ..###...
                        dc.b $28 ; 
                        dc.b $3c ; ..####..
                        dc.b $2b ; 
                        dc.b $7e ; .######.
                        dc.b $2e ; 
                        dc.b $7e ; .######.
                        dc.b $31 ; 
                        dc.b $7e ; .######.
                        dc.b $34 ; 
                        dc.b $7c ; .#####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $18 ; ...##...
                        dc.b $3d ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_41      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ; 
                        dc.b $18 ; ...##...
                        dc.b $1c ; 
                        dc.b $38 ; ..###...
                        dc.b $1f ; 
                        dc.b $3c ; ..####..
                        dc.b $22 ; 
                        dc.b $7c ; .#####..
                        dc.b $25 ; 
                        dc.b $7e ; .######.
                        dc.b $28 ; 
                        dc.b $7e ; .######.
                        dc.b $2b ; 
                        dc.b $7e ; .######.
                        dc.b $2e ; 
                        dc.b $7e ; .######.
                        dc.b $31 ; 
                        dc.b $7e ; .######.
                        dc.b $34 ; 
                        dc.b $7c ; .#####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $18 ; ...##...
                        dc.b $3d ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_42      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $10 ; 
                        dc.b $18 ; ...##...
                        dc.b $13 ; 
                        dc.b $38 ; ..###...
                        dc.b $16 ; 
                        dc.b $3c ; ..####..
                        dc.b $19 ; 
                        dc.b $7c ; .#####..
                        dc.b $1c ; 
                        dc.b $7e ; .######.
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $25 ; 
                        dc.b $ff ; ########
                        dc.b $28 ; 
                        dc.b $ff ; ########
                        dc.b $2b ; 
                        dc.b $ff ; ########
                        dc.b $2e ; 
                        dc.b $ff ; ########
                        dc.b $31 ; 
                        dc.b $7e ; .######.
                        dc.b $34 ; 
                        dc.b $7c ; .#####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $18 ; ...##...
                        dc.b $3d ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_43      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $07 ; 
                        dc.b $18 ; ...##...
                        dc.b $0a ; 
                        dc.b $1c ; ...###..
                        dc.b $0d ; 
                        dc.b $3c ; ..####..
                        dc.b $10 ; 
                        dc.b $7e ; .######.
                        dc.b $13 ; 
                        dc.b $7f ; .#######
                        dc.b $16 ; 
                        dc.b $ff ; ########
                        dc.b $18 ; 
                        dc.b $01 ; .......#
                        dc.b $19 ; 
                        dc.b $ff ; ########
                        dc.b $1b ; 
                        dc.b $01 ; .......#
                        dc.b $1c ; 
                        dc.b $ff ; ########
                        dc.b $1d ; 
                        dc.b $80 ; #.......
                        dc.b $1e ; 
                        dc.b $01 ; .......#
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $80 ; #.......
                        dc.b $21 ; 
                        dc.b $01 ; .......#
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $23 ; 
                        dc.b $80 ; #.......
                        dc.b $24 ; 
                        dc.b $01 ; .......#
                        dc.b $25 ; 
                        dc.b $ff ; ########
                        dc.b $26 ; 
                        dc.b $80 ; #.......
                        dc.b $27 ; 
                        dc.b $01 ; .......#
                        dc.b $28 ; 
                        dc.b $ff ; ########
                        dc.b $29 ; 
                        dc.b $80 ; #.......
                        dc.b $2b ; 
                        dc.b $ff ; ########
                        dc.b $2e ; 
                        dc.b $ff ; ########
                        dc.b $31 ; 
                        dc.b $7e ; .######.
                        dc.b $34 ; 
                        dc.b $7c ; .#####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $18 ; ...##...
                        dc.b $3d ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_44      dc.b $00 ; <flag: full sprite data>
                        
                        dc.b $00, $18, $00 ; ...........##...........
                        dc.b $00, $38, $00 ; ..........###...........
                        dc.b $00, $3c, $00 ; ..........####..........
                        dc.b $00, $7e, $00 ; .........######.........
                        dc.b $00, $ff, $00 ; ........########........
                        dc.b $00, $ff, $00 ; ........########........
                        dc.b $01, $ff, $80 ; .......##########.......
                        dc.b $01, $ff, $80 ; .......##########.......
                        dc.b $01, $ff, $80 ; .......##########.......
                        dc.b $01, $ff, $80 ; .......##########.......
                        dc.b $01, $ff, $80 ; .......##########.......
                        dc.b $01, $ff, $80 ; .......##########.......
                        dc.b $00, $ff, $80 ; ........#########.......
                        dc.b $00, $ff, $00 ; ........########........
                        dc.b $00, $7e, $00 ; .........######.........
                        dc.b $00, $7c, $00 ; .........#####..........
                        dc.b $00, $3c, $00 ; ..........####..........
                        dc.b $00, $38, $00 ; ..........###...........
                        dc.b $00, $18, $00 ; ...........##...........
                        dc.b $00, $18, $00 ; ...........##...........
                        dc.b $00, $18, $00 ; ...........##...........
                        
SpriteData_Ship_45      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0a ; 
                        dc.b $18 ; ...##...
                        dc.b $0d ; 
                        dc.b $24 ; ..#..#..
                        dc.b $10 ; 
                        dc.b $38 ; ..###...
                        dc.b $13 ; 
                        dc.b $4e ; .#..###.
                        dc.b $16 ; 
                        dc.b $bd ; #.####.#
                        dc.b $19 ; 
                        dc.b $57 ; .#.#.###
                        dc.b $1b ; 
                        dc.b $01 ; .......#
                        dc.b $1c ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $1d ; 
                        dc.b $80 ; #.......
                        dc.b $1e ; 
                        dc.b $01 ; .......#
                        dc.b $1f ; 
                        dc.b $a7 ; #.#..###
                        dc.b $20 ; 
                        dc.b $80 ; #.......
                        dc.b $22 ; 
                        dc.b $5d ; .#.###.#
                        dc.b $24 ; 
                        dc.b $01 ; .......#
                        dc.b $25 ; 
                        dc.b $eb ; ###.#.##
                        dc.b $26 ; 
                        dc.b $80 ; #.......
                        dc.b $28 ; 
                        dc.b $96 ; #..#.##.
                        dc.b $29 ; 
                        dc.b $80 ; #.......
                        dc.b $2b ; 
                        dc.b $7b ; .####.##
                        dc.b $2c ; 
                        dc.b $80 ; #.......
                        dc.b $2e ; 
                        dc.b $ad ; #.#.##.#
                        dc.b $31 ; 
                        dc.b $2e ; ..#.###.
                        dc.b $34 ; 
                        dc.b $44 ; .#...#..
                        dc.b $3a ; 
                        dc.b $10 ; ...#....
                        dc.b $3d ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_46      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $13 ; 
                        dc.b $08 ; ....#...
                        dc.b $16 ; 
                        dc.b $20 ; ..#.....
                        dc.b $19 ; 
                        dc.b $28 ; ..#.#...
                        dc.b $1c ; 
                        dc.b $56 ; .#.#.##.
                        dc.b $1f ; 
                        dc.b $cd ; ##..##.#
                        dc.b $22 ; 
                        dc.b $45 ; .#...#.#
                        dc.b $25 ; 
                        dc.b $36 ; ..##.##.
                        dc.b $26 ; 
                        dc.b $80 ; #.......
                        dc.b $27 ; 
                        dc.b $01 ; .......#
                        dc.b $28 ; 
                        dc.b $6e ; .##.###.
                        dc.b $29 ; 
                        dc.b $80 ; #.......
                        dc.b $2a ; 
                        dc.b $01 ; .......#
                        dc.b $2b ; 
                        dc.b $1b ; ...##.##
                        dc.b $2e ; 
                        dc.b $32 ; ..##..#.
                        dc.b $2f ; 
                        dc.b $80 ; #.......
                        dc.b $31 ; 
                        dc.b $bf ; #.######
                        dc.b $34 ; 
                        dc.b $ca ; ##..#.#.
                        dc.b $37 ; 
                        dc.b $76 ; .###.##.
                        dc.b $3a ; 
                        dc.b $48 ; .#..#...
                        dc.b $3d ; 
                        dc.b $24 ; ..#..#..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_47      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1c ; 
                        dc.b $18 ; ...##...
                        dc.b $1f ; 
                        dc.b $28 ; ..#.#...
                        dc.b $22 ; 
                        dc.b $10 ; ...#....
                        dc.b $25 ; 
                        dc.b $0e ; ....###.
                        dc.b $28 ; 
                        dc.b $63 ; .##...##
                        dc.b $2b ; 
                        dc.b $b0 ; #.##....
                        dc.b $2d ; 
                        dc.b $01 ; .......#
                        dc.b $2e ; 
                        dc.b $48 ; .#..#...
                        dc.b $2f ; 
                        dc.b $80 ; #.......
                        dc.b $31 ; 
                        dc.b $18 ; ...##...
                        dc.b $33 ; 
                        dc.b $01 ; .......#
                        dc.b $34 ; 
                        dc.b $b1 ; #.##...#
                        dc.b $35 ; 
                        dc.b $80 ; #.......
                        dc.b $37 ; 
                        dc.b $26 ; ..#..##.
                        dc.b $3a ; 
                        dc.b $98 ; #..##...
                        dc.b $3d ; 
                        dc.b $10 ; ...#....
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_48      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $25 ; 
                        dc.b $18 ; ...##...
                        dc.b $28 ; 
                        dc.b $0c ; ....##..
                        dc.b $2b ; 
                        dc.b $30 ; ..##....
                        dc.b $2e ; 
                        dc.b $66 ; .##..##.
                        dc.b $31 ; 
                        dc.b $18 ; ...##...
                        dc.b $34 ; 
                        dc.b $cd ; ##..##.#
                        dc.b $36 ; 
                        dc.b $01 ; .......#
                        dc.b $37 ; 
                        dc.b $21 ; ..#....#
                        dc.b $38 ; 
                        dc.b $80 ; #.......
                        dc.b $39 ; 
                        dc.b $01 ; .......#
                        dc.b $3a ; 
                        dc.b $8c ; #...##..
                        dc.b $3d ; 
                        dc.b $30 ; ..##....
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_49      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $2e ; 
                        dc.b $18 ; ...##...
                        dc.b $34 ; 
                        dc.b $0c ; ....##..
                        dc.b $37 ; 
                        dc.b $60 ; .##.....
                        dc.b $3a ; 
                        dc.b $cb ; ##..#.##
                        dc.b $3d ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_50      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $37 ; 
                        dc.b $18 ; ...##...
                        dc.b $3d ; 
                        dc.b $24 ; ..#..#..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_51      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $27 ; 
                        dc.b $04 ; .....#..
                        dc.b $28 ; 
                        dc.b $44 ; .#...#..
                        dc.b $29 ; 
                        dc.b $44 ; .#...#..
                        dc.b $2a ; 
                        dc.b $ff ; ########
                        dc.b $2b ; 
                        dc.b $ff ; ########
                        dc.b $2c ; 
                        dc.b $ff ; ########
                        dc.b $2d ; 
                        dc.b $0f ; ....####
                        dc.b $2e ; 
                        dc.b $ff ; ########
                        dc.b $2f ; 
                        dc.b $ff ; ########
                        dc.b $30 ; 
                        dc.b $03 ; ......##
                        dc.b $31 ; 
                        dc.b $ff ; ########
                        dc.b $32 ; 
                        dc.b $ff ; ########
                        dc.b $33 ; 
                        dc.b $03 ; ......##
                        dc.b $34 ; 
                        dc.b $ff ; ########
                        dc.b $35 ; 
                        dc.b $ff ; ########
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_52      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ; 
                        dc.b $73 ; .###..##
                        dc.b $1c ; 
                        dc.b $7f ; .#######
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $21 ; 
                        dc.b $03 ; ......##
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $23 ; 
                        dc.b $c0 ; ##......
                        dc.b $25 ; 
                        dc.b $ff ; ########
                        dc.b $2b ; 
                        dc.b $40 ; .#......
                        dc.b $28 ; 
                        dc.b $ff ; ########
                        dc.b $29 ; 
                        dc.b $f0 ; ####....
                        dc.b $2a ; 
                        dc.b $ff ; ########
                        dc.b $2b ; 
                        dc.b $ff ; ########
                        dc.b $2c ; 
                        dc.b $ff ; ########
                        dc.b $2d ; 
                        dc.b $ff ; ########
                        dc.b $2e ; 
                        dc.b $ff ; ########
                        dc.b $2f ; 
                        dc.b $ff ; ########
                        dc.b $30 ; 
                        dc.b $ff ; ########
                        dc.b $31 ; 
                        dc.b $ff ; ########
                        dc.b $32 ; 
                        dc.b $ff ; ########
                        dc.b $33 ; 
                        dc.b $ff ; ########
                        dc.b $34 ; 
                        dc.b $ff ; ########
                        dc.b $35 ; 
                        dc.b $ff ; ########
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_53      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $27 ; 
                        dc.b $08 ; ....#...
                        dc.b $28 ; 
                        dc.b $88 ; #...#...
                        dc.b $29 ; 
                        dc.b $80 ; #.......
                        dc.b $2a ; 
                        dc.b $ff ; ########
                        dc.b $2b ; 
                        dc.b $ff ; ########
                        dc.b $2c ; 
                        dc.b $ff ; ########
                        dc.b $2d ; 
                        dc.b $ff ; ########
                        dc.b $2e ; 
                        dc.b $ff ; ########
                        dc.b $2f ; 
                        dc.b $f0 ; ####....
                        dc.b $30 ; 
                        dc.b $ff ; ########
                        dc.b $31 ; 
                        dc.b $ff ; ########
                        dc.b $32 ; 
                        dc.b $f0 ; ####....
                        dc.b $33 ; 
                        dc.b $ff ; ########
                        dc.b $34 ; 
                        dc.b $ff ; ########
                        dc.b $35 ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_54      dc.b $00 ; <flag: full sprite data>
                        
                        dc.b $ff, $ff, $ff ; ########################
                        dc.b $ff, $ff, $ff ; ########################
                        dc.b $ff, $ff, $ff ; ########################
                        dc.b $ff, $ff, $ff ; ########################
                        dc.b $ff, $ff, $ff ; ########################
                        dc.b $ff, $ff, $ff ; ########################
                        dc.b $ff, $ff, $ff ; ########################
                        dc.b $ff, $ff, $ff ; ########################
                        dc.b $ff, $ff, $ff ; ########################
                        dc.b $ff, $ff, $ff ; ########################
                        dc.b $ff, $ff, $ff ; ########################
                        dc.b $ff, $ff, $ff ; ########################
                        dc.b $ff, $ff, $ff ; ########################
                        dc.b $ff, $ff, $ff ; ########################
                        dc.b $ff, $ff, $ff ; ########################
                        dc.b $ff, $ff, $ff ; ########################
                        dc.b $ff, $ff, $ff ; ########################
                        dc.b $ff, $ff, $ff ; ########################
                        dc.b $ff, $ff, $ff ; ########################
                        dc.b $ff, $ff, $ff ; ########################
                        dc.b $ff, $ff, $ff ; ########################
                        
SpriteData_Ship_55      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $15 ; 
                        dc.b $01 ; .......#
                        dc.b $18 ; 
                        dc.b $03 ; ......##
                        dc.b $19 ; 
                        dc.b $80 ; #.......
                        dc.b $1b ; 
                        dc.b $01 ; .......#
                        dc.b $1e ; 
                        dc.b $03 ; ......##
                        dc.b $1f ; 
                        dc.b $80 ; #.......
                        dc.b $21 ; 
                        dc.b $07 ; .....###
                        dc.b $22 ; 
                        dc.b $c0 ; ##......
                        dc.b $24 ; 
                        dc.b $0f ; ....####
                        dc.b $25 ; 
                        dc.b $e0 ; ###.....
                        dc.b $27 ; 
                        dc.b $1f ; ...#####
                        dc.b $28 ; 
                        dc.b $f0 ; ####....
                        dc.b $2a ; 
                        dc.b $1f ; ...#####
                        dc.b $2b ; 
                        dc.b $f0 ; ####....
                        dc.b $2d ; 
                        dc.b $1f ; ...#####
                        dc.b $2e ; 
                        dc.b $f0 ; ####....
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_56      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $25 ; 
                        dc.b $40 ; .#......
                        dc.b $28 ; 
                        dc.b $60 ; .##.....
                        dc.b $2a ; 
                        dc.b $01 ; .......#
                        dc.b $2b ; 
                        dc.b $f0 ; ####....
                        dc.b $2d ; 
                        dc.b $07 ; .....###
                        dc.b $2e ; 
                        dc.b $ff ; ########
                        dc.b $30 ; 
                        dc.b $ff ; ########
                        dc.b $31 ; 
                        dc.b $fc ; ######..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_57      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $22 ; 
                        dc.b $10 ; ...#....
                        dc.b $25 ; 
                        dc.b $38 ; ..###...
                        dc.b $28 ; 
                        dc.b $7c ; .#####..
                        dc.b $2b ; 
                        dc.b $fe ; #######.
                        dc.b $2e ; 
                        dc.b $fe ; #######.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Ship_58      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $18 ; 
                        dc.b $02 ; ......#.
                        dc.b $1b ; 
                        dc.b $02 ; ......#.
                        dc.b $1c ; 
                        dc.b $80 ; #.......
                        dc.b $1e ; 
                        dc.b $07 ; .....###
                        dc.b $1f ; 
                        dc.b $80 ; #.......
                        dc.b $21 ; 
                        dc.b $ff ; ########
                        dc.b $22 ; 
                        dc.b $80 ; #.......
                        dc.b $24 ; 
                        dc.b $3f ; ..######
                        dc.b $25 ; 
                        dc.b $f0 ; ####....
                        dc.b $27 ; 
                        dc.b $1f ; ...#####
                        dc.b $28 ; 
                        dc.b $ff ; ########
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SpriteData_Tank_02      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ;             ; ........................ ; $00 $01 $02
                        dc.b $3f ; ..######    ; ........................ ; $03 $04 $05
                        dc.b $1a ;             ; ........................ ; $06 $07 $08
                        dc.b $c0 ; ##......    ; ........................ ; $09 $0a $0b
                        dc.b $1c ;             ; ........................ ; $0c $0d $0e
                        dc.b $3f ; ..######    ; ........................ ; $0f $10 $11
                        dc.b $1d ;             ; ........................ ; $12 $13 $14
                        dc.b $c0 ; ##......    ; ........................ ; $15 $16 $17
                        dc.b $1e ;             ; ..........########...... ; $18 $19 $1a
                        dc.b $ff ; ########    ; ..........########...... ; $1b $1c $1d
                        dc.b $1f ;             ; ##########.#.#.#.##.#... ; $1e $1f $20
                        dc.b $d5 ; ##.#.#.#    ; ....#.#.#..#.#.#.##.#... ; $21 $22 $23
                        dc.b $20 ;             ; ....#.#.#.#.#.#.#.#.#... ; $24 $25 $26
                        dc.b $68 ; .##.#...    ; ....##.###.###.###.###.. ; $27 $28 $29
                        dc.b $21 ;             ; .....###############.#.. ; $2a $2b $2c
                        dc.b $0a ; ....#.#.    ; ....##.###.###.###.###.. ; $2d $2e $2f
                        dc.b $22 ;             ; ........................ ; $30 $31 $32
                        dc.b $95 ; #..#.#.#    ; ........................ ; $33 $34 $35
                        dc.b $23 ;             ; ........................ ; $36 $37 $38
                        dc.b $68 ; .##.#...    ; ........................ ; $39 $3a $3b
                        dc.b $24 ;             ; ........................ ; $3c $3d $3e
                        dc.b $0a ; ....#.#.
                        dc.b $25 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $26 ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $27 ; 
                        dc.b $0d ; ....##.#
                        dc.b $28 ; 
                        dc.b $dd ; ##.###.#
                        dc.b $29 ; 
                        dc.b $dc ; ##.###..
                        dc.b $2a ; 
                        dc.b $07 ; .....###
                        dc.b $2b ; 
                        dc.b $ff ; ########
                        dc.b $2c ; 
                        dc.b $f4 ; ####.#..
                        dc.b $2d ; 
                        dc.b $0d ; ....##.#
                        dc.b $2e ; 
                        dc.b $dd ; ##.###.#
                        dc.b $2f ; 
                        dc.b $dc ; ##.###..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Tank_03      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $16 ;             ; ........................ ; $00 $01 $02
                        dc.b $a0 ; #.#.....    ; ........................ ; $03 $04 $05
                        dc.b $18 ;             ; ........................ ; $06 $07 $08
                        dc.b $02 ; ......#.    ; ........................ ; $09 $0a $0b
                        dc.b $19 ;             ; ........................ ; $0c $0d $0e
                        dc.b $bf ; #.######    ; ........................ ; $0f $10 $11
                        dc.b $1a ;             ; ........................ ; $12 $13 $14
                        dc.b $c0 ; ##......    ; ........#.#............. ; $15 $16 $17
                        dc.b $1b ;             ; ......#.#.########...... ; $18 $19 $1a
                        dc.b $0a ; ....#.#.    ; ....#.#.#.########...... ; $1b $1c $1d
                        dc.b $1c ;             ; ##########.#.#.#.##..... ; $1e $1f $20
                        dc.b $bf ; #.######    ; ....#####..#.#.#.##.#... ; $21 $22 $23
                        dc.b $1d ;             ; ....#######.#.#.#.#.##.. ; $24 $25 $26
                        dc.b $c0 ; ##......    ; ......#######.#.#..###.. ; $27 $28 $29
                        dc.b $1e ;             ; ........#######..#.###.. ; $2a $2b $2c
                        dc.b $ff ; ########    ; ..........######.#.#.... ; $2d $2e $2f
                        dc.b $1f ;             ; ............####.#...... ; $30 $31 $32
                        dc.b $d5 ; ##.#.#.#    ; ..............##........ ; $33 $34 $35
                        dc.b $20 ;             ; ........................ ; $36 $37 $38
                        dc.b $60 ; .##.....    ; ........................ ; $39 $3a $3b
                        dc.b $21 ;             ; ........................ ; $3c $3d $3e
                        dc.b $0f ; ....####
                        dc.b $22 ; 
                        dc.b $95 ; #..#.#.#
                        dc.b $23 ; 
                        dc.b $68 ; .##.#...
                        dc.b $24 ; 
                        dc.b $0f ; ....####
                        dc.b $25 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $26 ; 
                        dc.b $ac ; #.#.##..
                        dc.b $27 ; 
                        dc.b $03 ; ......##
                        dc.b $28 ; 
                        dc.b $fa ; #####.#.
                        dc.b $29 ; 
                        dc.b $9c ; #..###..
                        dc.b $2b ; 
                        dc.b $fe ; #######.
                        dc.b $2c ; 
                        dc.b $5c ; .#.###..
                        dc.b $2e ; 
                        dc.b $3f ; ..######
                        dc.b $2f ; 
                        dc.b $50 ; .#.#....
                        dc.b $31 ; 
                        dc.b $0f ; ....####
                        dc.b $32 ; 
                        dc.b $40 ; .#......
                        dc.b $34 ; 
                        dc.b $03 ; ......##
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Tank_04      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ;             ; ........................ ; $00 $01 $02
                        dc.b $3f ; ..######    ; ........................ ; $03 $04 $05
                        dc.b $1a ;             ; ........................ ; $06 $07 $08
                        dc.b $c0 ; ##......    ; ........................ ; $09 $0a $0b
                        dc.b $1c ;             ; ........................ ; $0c $0d $0e
                        dc.b $3f ; ..######    ; ........................ ; $0f $10 $11
                        dc.b $1d ;             ; ........................ ; $12 $13 $14
                        dc.b $e0 ; ###.....    ; ........................ ; $15 $16 $17
                        dc.b $1e ;             ; ..........########...... ; $18 $19 $1a
                        dc.b $ff ; ########    ; ..........#########..... ; $1b $1c $1d
                        dc.b $1f ;             ; ##########.#.#.#.##.#... ; $1e $1f $20
                        dc.b $d5 ; ##.#.#.#    ; ........#..#.#.#.##.##.. ; $21 $22 $23
                        dc.b $20 ;             ; ......#.#.#.#.#.#.####.. ; $24 $25 $26
                        dc.b $68 ; .##.#...    ; ....###.#.#.#.#.######.. ; $27 $28 $29
                        dc.b $22 ;             ; ....##.##.#.#.######.... ; $2a $2b $2c
                        dc.b $95 ; #..#.#.#    ; ....##.#.##.######...... ; $2d $2e $2f
                        dc.b $23 ;             ; .......#.#######.#####.. ; $30 $31 $32
                        dc.b $6c ; .##.##..    ; ..........##............ ; $33 $34 $35
                        dc.b $24 ;             ; ........................ ; $36 $37 $38
                        dc.b $02 ; ......#.    ; ........................ ; $39 $3a $3b
                        dc.b $25 ;             ; ........................ ; $3c $3d $3e
                        dc.b $aa ; #.#.#.#.
                        dc.b $26 ; 
                        dc.b $bc ; #.####..
                        dc.b $27 ; 
                        dc.b $0e ; ....###.
                        dc.b $28 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $29 ; 
                        dc.b $fc ; ######..
                        dc.b $2a ; 
                        dc.b $0d ; ....##.#
                        dc.b $2b ; 
                        dc.b $ab ; #.#.#.##
                        dc.b $2c ; 
                        dc.b $f0 ; ####....
                        dc.b $2d ; 
                        dc.b $0d ; ....##.#
                        dc.b $2e ; 
                        dc.b $6f ; .##.####
                        dc.b $2f ; 
                        dc.b $c0 ; ##......
                        dc.b $30 ; 
                        dc.b $01 ; .......#
                        dc.b $31 ; 
                        dc.b $7f ; .#######
                        dc.b $34 ; 
                        dc.b $7c ; .#####..
                        dc.b $37 ; 
                        dc.b $30 ; ..##....
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Tank_05      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1e ; 
                        dc.b $f8 ; #####...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Tank_06      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $20 ; 
                        dc.b $1f ; ...#####
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Tank_07      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $12 ;             ; ........ ........ ........ ; $00 $01 $02
                        dc.b $0a ; ....#.#.    ; ........ ........ ........ ; $03 $04 $05
                        dc.b $13 ;             ; ........ ........ ........ ; $06 $07 $08
                        dc.b $a0 ; #.#.....    ; ........ ........ ........ ; $09 $0a $0b
                        dc.b $15 ;             ; ........ ........ ........ ; $0c $0d $0e
                        dc.b $2a ; ..#.#.#.    ; ........ ........ ........ ; $0f $10 $11
                        dc.b $16 ;             ; ....#.#. #.#..... ........ ; $12 $13 $14
                        dc.b $a8 ; #.#.#...    ; ..#.#.#. #.#.#... ........ ; $15 $16 $17
                        dc.b $18 ;             ; #.#.#.#. #.#.#.#. ........ ; $18 $19 $1a
                        dc.b $aa ; #.#.#.#.    ; #.#.#.#. #.#.#.#. ........ ; $1b $1c $1d
                        dc.b $19 ;             ; .##.#.#. #.#.#..# ######## ; $1e $1f $20
                        dc.b $aa ; #.#.#.#.    ; .#.##.#. #.#..#.# ........ ; $21 $22 $23
                        dc.b $1b ;             ; .#.#.#.# .#.#.#.# ........ ; $24 $25 $26
                        dc.b $aa ; #.#.#.#.    ; #..#.#.# .#.#.##. ........ ; $27 $28 $29
                        dc.b $1c ;             ; ..#..#.# .#.##... ........ ; $2a $2b $2c
                        dc.b $aa ; #.#.#.#.    ; ....#.#. #.#..... ........ ; $2d $2e $2f
                        dc.b $1e ;             ; ........ ........ ........ ; $30 $31 $32
                        dc.b $6a ; .##.#.#.    ; ........ ........ ........ ; $33 $34 $35
                        dc.b $1f ;             ; ........ ........ ........ ; $36 $37 $38
                        dc.b $a9 ; #.#.#..#    ; ........ ........ ........ ; $39 $3a $3b
                        dc.b $20 ;             ; ........ ........ ........ ; $3c $3d $3e
                        dc.b $ff ; ########
                        dc.b $21 ; 
                        dc.b $5a ; .#.##.#.
                        dc.b $22 ; 
                        dc.b $a5 ; #.#..#.#
                        dc.b $24 ; 
                        dc.b $55 ; .#.#.#.#
                        dc.b $25 ; 
                        dc.b $55 ; .#.#.#.#
                        dc.b $27 ; 
                        dc.b $95 ; #..#.#.#
                        dc.b $28 ; 
                        dc.b $56 ; .#.#.##.
                        dc.b $2a ; 
                        dc.b $25 ; ..#..#.#
                        dc.b $2b ; 
                        dc.b $58 ; .#.##...
                        dc.b $2d ; 
                        dc.b $0a ; ....#.#.
                        dc.b $2e ; 
                        dc.b $a0 ; #.#.....
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Tank_08      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ;            ; ........................ ; $00 $01 $02
                        dc.b $aa ; #.#.#.#.   ; ........................ ; $03 $04 $05
                        dc.b $1c ;            ; ........................ ; $06 $07 $08
                        dc.b $aa ; #.#.#.#.   ; ........................ ; $09 $0a $0b
                        dc.b $1e ;            ; ........................ ; $0c $0d $0e
                        dc.b $03 ; ......##   ; ........................ ; $0f $10 $11
                        dc.b $1f ;            ; ........................ ; $12 $13 $14
                        dc.b $aa ; #.#.#.#.   ; ........................ ; $15 $16 $17
                        dc.b $20 ;            ; ........#.#.#.#......... ; $18 $19 $1a
                        dc.b $ff ; ########   ; ........#.#.#.#......... ; $1b $1c $1d
                        dc.b $21 ;            ; ......###.#.#.#.######## ; $1e $1f $20
                        dc.b $01 ; .......#   ; .......##.#.#.#..#...... ; $21 $22 $23
                        dc.b $22 ;            ; ......##.#.#.#.###...... ; $24 $25 $26
                        dc.b $aa ; #.#.#.#.   ; .......#.#.#.#.#.#...... ; $27 $28 $29
                        dc.b $23 ;            ; ......###.#.#.#.##...... ; $2a $2b $2c
                        dc.b $40 ; .#......   ; .......##.#.#.#..#...... ; $2d $2e $2f
                        dc.b $24 ;            ; ......##.#.#.#.###...... ; $30 $31 $32
                        dc.b $03 ; ......##   ; ......##.#.#.#.###...... ; $33 $34 $35
                        dc.b $25 ;            ; ......##........##...... ; $36 $37 $38
                        dc.b $55 ; .#.#.#.#   ; ........................ ; $39 $3a $3b
                        dc.b $26 ;            ; ........................ ; $3c $3d $3e
                        dc.b $c0 ; ##......
                        dc.b $27 ; 
                        dc.b $01 ; .......#
                        dc.b $28 ; 
                        dc.b $55 ; .#.#.#.#
                        dc.b $29 ; 
                        dc.b $40 ; .#......
                        dc.b $2a ; 
                        dc.b $03 ; ......##
                        dc.b $2b ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $2c ; 
                        dc.b $c0 ; ##......
                        dc.b $2d ; 
                        dc.b $01 ; .......#
                        dc.b $2e ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $2f ; 
                        dc.b $40 ; .#......
                        dc.b $30 ; 
                        dc.b $03 ; ......##
                        dc.b $31 ; 
                        dc.b $55 ; .#.#.#.#
                        dc.b $32 ; 
                        dc.b $c0 ; ##......
                        dc.b $33 ; 
                        dc.b $03 ; ......##
                        dc.b $34 ; 
                        dc.b $55 ; .#.#.#.#
                        dc.b $35 ; 
                        dc.b $c0 ; ##......
                        dc.b $36 ; 
                        dc.b $03 ; ......##
                        dc.b $38 ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Tank_09      dc.b $00 ; <flag: full sprite data>
                        
                        dc.b $00, $00, $00     ; ........................ ; $00 $01 $02
                        dc.b $00, $00, $00     ; ........................ ; $03 $04 $05
                        dc.b $00, $00, $00     ; ........................ ; $06 $07 $08
                        dc.b $00, $80, $00     ; ........#............... ; $09 $0a $0b
                        dc.b $00, $60, $00     ; .........##............. ; $0c $0d $0e
                        dc.b $03, $58, $00     ; ......##.#.##........... ; $0f $10 $11
                        dc.b $03, $d6, $00     ; ......####.#.##......... ; $12 $13 $14
                        dc.b $33, $05, $80     ; ..##..##.....#.##....... ; $15 $16 $17
                        dc.b $3c, $01, $60     ; ..####.........#.##..... ; $18 $19 $1a
                        dc.b $33, $f0, $60     ; ..##..######.....##..... ; $1b $1c $1d
                        dc.b $33, $ff, $ff     ; ..##..################## ; $1e $1f $20
                        dc.b $33, $00, $20     ; ..##..##..........#..... ; $21 $22 $23
                        dc.b $0c, $c0, $20     ; ....##..##........#..... ; $24 $25 $26
                        dc.b $30, $30, $20     ; ..##......##......#..... ; $27 $28 $29
                        dc.b $03, $00, $a0     ; ......##........#.#..... ; $2a $2b $2c
                        dc.b $03, $c2, $a0     ; ......####....#.#.#..... ; $2d $2e $2f
                        dc.b $03, $0a, $80     ; ......##....#.#.#....... ; $30 $31 $32
                        dc.b $0f, $2a, $00     ; ....####..#.#.#......... ; $33 $34 $35
                        dc.b $00, $a8, $00     ; ........#.#.#........... ; $36 $37 $38
                        dc.b $00, $a0, $00     ; ........#.#............. ; $39 $3a $3b
                        dc.b $00, $80, $00     ; ........#............... ; $3c $3d $3e
                        
                        
SpriteData_Tank_10      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $13 ;             ; ........................ ; $00 $01 $02
                        dc.b $80 ; #.......    ; ........................ ; $03 $04 $05
                        dc.b $15 ;             ; ........................ ; $06 $07 $08
                        dc.b $02 ; ......#.    ; ........................ ; $09 $0a $0b
                        dc.b $16 ;             ; ........................ ; $0c $0d $0e
                        dc.b $a0 ; #.#.....    ; ........................ ; $0f $10 $11
                        dc.b $18 ;             ; ........#............... ; $12 $13 $14
                        dc.b $0a ; ....#.#.    ; ......#.#.#............. ; $15 $16 $17
                        dc.b $19 ;             ; ....#.#.#.#.#........... ; $18 $19 $1a
                        dc.b $a8 ; #.#.#...    ; ..#.#.#.#.#.#.#......... ; $1b $1c $1d
                        dc.b $1b ;             ; ...##.#.#.#.#..######### ; $1e $1f $20
                        dc.b $2a ; ..#.#.#.    ; ...#.##.#.#..#.#........ ; $21 $22 $23
                        dc.b $1c ;             ; ...#.#.##..#.#.#........ ; $24 $25 $26
                        dc.b $aa ; #.#.#.#.    ; ..##.#.#.#.#.###........ ; $27 $28 $29
                        dc.b $1e ;             ; ..##...#.#.#..##........ ; $2a $2b $2c
                        dc.b $1a ; ...##.#.    ; ..##.....#....##........ ; $2d $2e $2f
                        dc.b $1f ;             ; ..##....##....##........ ; $30 $31 $32
                        dc.b $a9 ; #.#.#..#    ; ..##....##....##........ ; $33 $34 $35
                        dc.b $20 ;             ; ........##.............. ; $36 $37 $38
                        dc.b $ff ; ########    ; ........##.............. ; $39 $3a $3b
                        dc.b $21 ;             ; ........##.............. ; $3c $3d $3e
                        dc.b $16 ; ...#.##.
                        dc.b $22 ; 
                        dc.b $a5 ; #.#..#.#
                        dc.b $24 ; 
                        dc.b $15 ; ...#.#.#
                        dc.b $25 ; 
                        dc.b $95 ; #..#.#.#
                        dc.b $27 ; 
                        dc.b $35 ; ..##.#.#
                        dc.b $28 ; 
                        dc.b $57 ; .#.#.###
                        dc.b $2a ; 
                        dc.b $31 ; ..##...#
                        dc.b $2b ; 
                        dc.b $53 ; .#.#..##
                        dc.b $2d ; 
                        dc.b $30 ; ..##....
                        dc.b $2e ; 
                        dc.b $43 ; .#....##
                        dc.b $30 ; 
                        dc.b $30 ; ..##....
                        dc.b $31 ; 
                        dc.b $c3 ; ##....##
                        dc.b $33 ; 
                        dc.b $30 ; ..##....
                        dc.b $34 ; 
                        dc.b $c3 ; ##....##
                        dc.b $37 ; 
                        dc.b $c0 ; ##......
                        dc.b $3a ; 
                        dc.b $c0 ; ##......
                        dc.b $3d ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Tank_11      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $15 ;             ; ........................ ; $00 $01 $02
                        dc.b $fc ; ######..    ; ........................ ; $03 $04 $05
                        dc.b $16 ;             ; ........................ ; $06 $07 $08
                        dc.b $7e ; .######.    ; ........................ ; $09 $0a $0b
                        dc.b $17 ;             ; ........................ ; $0c $0d $0e
                        dc.b $3f ; ..######    ; ........................ ; $0f $10 $11
                        dc.b $18 ;             ; ........................ ; $12 $13 $14
                        dc.b $cc ; ##..##..    ; ######...######...###### ; $15 $16 $17
                        dc.b $19 ;             ; ##..##...##..##...##..## ; $18 $19 $1a
                        dc.b $66 ; .##..##.    ; ...###...##..##...##..## ; $1b $1c $1d
                        dc.b $1a ;             ; .###.....##..##...##..## ; $1e $1f $20
                        dc.b $33 ; ..##..##    ; ##.......##..##...##..## ; $21 $22 $23
                        dc.b $1b ;             ; ##..##...##..##...##..## ; $24 $25 $26
                        dc.b $1c ; ...###..    ; ######...######...###### ; $27 $28 $29
                        dc.b $1c ;             ; ........................ ; $2a $2b $2c
                        dc.b $66 ; .##..##.    ; ........................ ; $2d $2e $2f
                        dc.b $1d ;             ; ........................ ; $30 $31 $32
                        dc.b $33 ; ..##..##    ; ........................ ; $33 $34 $35
                        dc.b $1e ;             ; ........................ ; $36 $37 $38
                        dc.b $70 ; .###....    ; ........................ ; $39 $3a $3b
                        dc.b $1f ;             ; ........................ ; $3c $3d $3e
                        dc.b $66 ; .##..##.
                        dc.b $20 ; 
                        dc.b $33 ; ..##..##
                        dc.b $21 ; 
                        dc.b $c0 ; ##......
                        dc.b $22 ; 
                        dc.b $66 ; .##..##.
                        dc.b $23 ; 
                        dc.b $33 ; ..##..##
                        dc.b $24 ; 
                        dc.b $cc ; ##..##..
                        dc.b $25 ; 
                        dc.b $66 ; .##..##.
                        dc.b $26 ; 
                        dc.b $33 ; ..##..##
                        dc.b $27 ; 
                        dc.b $fc ; ######..
                        dc.b $28 ; 
                        dc.b $7e ; .######.
                        dc.b $29 ; 
                        dc.b $3f ; ..######
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Tank_12      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $15 ;             ; ........................ ; $00 $01 $02
                        dc.b $cc ; ##..##..    ; ........................ ; $03 $04 $05
                        dc.b $16 ;             ; ........................ ; $06 $07 $08
                        dc.b $7e ; .######.    ; ........................ ; $09 $0a $0b
                        dc.b $17 ;             ; ........................ ; $0c $0d $0e
                        dc.b $3f ; ..######    ; ........................ ; $0f $10 $11
                        dc.b $18 ;             ; ........................ ; $12 $13 $14
                        dc.b $cc ; ##..##..    ; ##..##...######...###### ; $15 $16 $17
                        dc.b $19 ;             ; ##..##...##..##...##..## ; $18 $19 $1a
                        dc.b $66 ; .##..##.    ; ##..##...##..##...##..## ; $1b $1c $1d
                        dc.b $1a ;             ; ######...##..##...##..## ; $1e $1f $20
                        dc.b $33 ; ..##..##    ; ....##...##..##...##..## ; $21 $22 $23
                        dc.b $1b ;             ; ....##...##..##...##..## ; $24 $25 $26
                        dc.b $cc ; ##..##..    ; ....##...######...###### ; $27 $28 $29
                        dc.b $1c ;             ; ........................ ; $2a $2b $2c
                        dc.b $66 ; .##..##.    ; ........................ ; $2d $2e $2f
                        dc.b $1d ;             ; ........................ ; $30 $31 $32
                        dc.b $33 ; ..##..##    ; ........................ ; $33 $34 $35
                        dc.b $1e ;             ; ........................ ; $36 $37 $38
                        dc.b $fc ; ######..    ; ........................ ; $39 $3a $3b
                        dc.b $1f ;             ; ........................ ; $3c $3d $3e
                        dc.b $66 ; .##..##.
                        dc.b $20 ; 
                        dc.b $33 ; ..##..##
                        dc.b $21 ; 
                        dc.b $0c ; ....##..
                        dc.b $22 ; 
                        dc.b $66 ; .##..##.
                        dc.b $23 ; 
                        dc.b $33 ; ..##..##
                        dc.b $24 ; 
                        dc.b $0c ; ....##..
                        dc.b $25 ; 
                        dc.b $66 ; .##..##.
                        dc.b $26 ; 
                        dc.b $33 ; ..##..##
                        dc.b $27 ; 
                        dc.b $0c ; ....##..
                        dc.b $28 ; 
                        dc.b $7e ; .######.
                        dc.b $29 ; 
                        dc.b $3f ; ..######
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Tank_13      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $15 ;             ; ........................ ; $00 $01 $02
                        dc.b $fc ; ######..    ; ........................ ; $03 $04 $05
                        dc.b $16 ;             ; ........................ ; $06 $07 $08
                        dc.b $7e ; .######.    ; ........................ ; $09 $0a $0b
                        dc.b $17 ;             ; ........................ ; $0c $0d $0e
                        dc.b $3f ; ..######    ; ........................ ; $0f $10 $11
                        dc.b $18 ;             ; ........................ ; $12 $13 $14
                        dc.b $cc ; ##..##..    ; ######...######...###### ; $15 $16 $17
                        dc.b $19 ;             ; ##..##...##..##...##..## ; $18 $19 $1a
                        dc.b $66 ; .##..##.    ; ##.......##..##...##..## ; $1b $1c $1d
                        dc.b $1a ;             ; ######...##..##...##..## ; $1e $1f $20
                        dc.b $33 ; ..##..##    ; ##..##...##..##...##..## ; $21 $22 $23
                        dc.b $1b ;             ; ##..##...##..##...##..## ; $24 $25 $26
                        dc.b $c0 ; ##......    ; ######...######...###### ; $27 $28 $29
                        dc.b $1c ;             ; ........................ ; $2a $2b $2c
                        dc.b $66 ; .##..##.    ; ........................ ; $2d $2e $2f
                        dc.b $1d ;             ; ........................ ; $30 $31 $32
                        dc.b $33 ; ..##..##    ; ........................ ; $33 $34 $35
                        dc.b $1e ;             ; ........................ ; $36 $37 $38
                        dc.b $fc ; ######..    ; ........................ ; $39 $3a $3b
                        dc.b $1f ;             ; ........................ ; $3c $3d $3e
                        dc.b $66 ; .##..##.
                        dc.b $20 ; 
                        dc.b $33 ; ..##..##
                        dc.b $21 ; 
                        dc.b $cc ; ##..##..
                        dc.b $22 ; 
                        dc.b $66 ; .##..##.
                        dc.b $23 ; 
                        dc.b $33 ; ..##..##
                        dc.b $24 ; 
                        dc.b $cc ; ##..##..
                        dc.b $25 ; 
                        dc.b $66 ; .##..##.
                        dc.b $26 ; 
                        dc.b $33 ; ..##..##
                        dc.b $27 ; 
                        dc.b $fc ; ######..
                        dc.b $28 ; 
                        dc.b $7e ; .######.
                        dc.b $29 ; 
                        dc.b $3f ; ..######
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Tank_14      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $15 ;             ; ........................ ; $00 $01 $02
                        dc.b $fc ; ######..    ; ........................ ; $03 $04 $05
                        dc.b $16 ;             ; ........................ ; $06 $07 $08
                        dc.b $7e ; .######.    ; ........................ ; $09 $0a $0b
                        dc.b $17 ;             ; ........................ ; $0c $0d $0e
                        dc.b $3f ; ..######    ; ........................ ; $0f $10 $11
                        dc.b $18 ;             ; ........................ ; $12 $13 $14
                        dc.b $cc ; ##..##..    ; ######...######...###### ; $15 $16 $17
                        dc.b $19 ;             ; ##..##...##..##...##..## ; $18 $19 $1a
                        dc.b $66 ; .##..##.    ; ##..##...##..##...##..## ; $1b $1c $1d
                        dc.b $1a ;             ; .####....##..##...##..## ; $1e $1f $20
                        dc.b $33 ; ..##..##    ; ##..##...##..##...##..## ; $21 $22 $23
                        dc.b $1b ;             ; ##..##...##..##...##..## ; $24 $25 $26
                        dc.b $cc ; ##..##..    ; ######...######...###### ; $27 $28 $29
                        dc.b $1c ;             ; ........................ ; $2a $2b $2c
                        dc.b $66 ; .##..##.    ; ........................ ; $2d $2e $2f
                        dc.b $1d ;             ; ........................ ; $30 $31 $32
                        dc.b $33 ; ..##..##    ; ........................ ; $33 $34 $35
                        dc.b $1e ;             ; ........................ ; $36 $37 $38
                        dc.b $78 ; .####...    ; ........................ ; $39 $3a $3b
                        dc.b $1f ;             ; ........................ ; $3c $3d $3e
                        dc.b $66 ; .##..##.
                        dc.b $20 ; 
                        dc.b $33 ; ..##..##
                        dc.b $21 ; 
                        dc.b $cc ; ##..##..
                        dc.b $22 ; 
                        dc.b $66 ; .##..##.
                        dc.b $23 ; 
                        dc.b $33 ; ..##..##
                        dc.b $24 ; 
                        dc.b $cc ; ##..##..
                        dc.b $25 ; 
                        dc.b $66 ; .##..##.
                        dc.b $26 ; 
                        dc.b $33 ; ..##..##
                        dc.b $27 ; 
                        dc.b $fc ; ######..
                        dc.b $28 ; 
                        dc.b $7e ; .######.
                        dc.b $29 ; 
                        dc.b $3f ; ..######
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Tank_15      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $00 ;             ; ##...................... ; $00 $01 $02
                        dc.b $c0 ; ##......    ; ##...................... ; $03 $04 $05
                        dc.b $03 ;             ; ##...................... ; $06 $07 $08
                        dc.b $c0 ; ##......    ; ##...................... ; $09 $0a $0b
                        dc.b $06 ;             ; ##...................... ; $0c $0d $0e
                        dc.b $c0 ; ##......    ; ....######.............. ; $0f $10 $11
                        dc.b $09 ;             ; ....##..##.............. ; $12 $13 $14
                        dc.b $c0 ; ##......    ; ....##..##.............. ; $15 $16 $17
                        dc.b $0c ;             ; ....##..##.............. ; $18 $19 $1a
                        dc.b $c0 ; ##......    ; ....######.............. ; $1b $1c $1d
                        dc.b $0f ;             ; ...........######....... ; $1e $1f $20
                        dc.b $0f ; ....####    ; ...........##..##....... ; $21 $22 $23
                        dc.b $10 ;             ; ...........##..##....... ; $24 $25 $26
                        dc.b $c0 ; ##......    ; ...........##..##....... ; $27 $28 $29
                        dc.b $12 ;             ; ...........######....... ; $2a $2b $2c
                        dc.b $0c ; ....##..    ; ..................###### ; $2d $2e $2f
                        dc.b $13 ;             ; ..................##..## ; $30 $31 $32
                        dc.b $c0 ; ##......    ; ..................##..## ; $33 $34 $35
                        dc.b $15 ;             ; ..................##..## ; $36 $37 $38
                        dc.b $0c ; ....##..    ; ..................###### ; $39 $3a $3b
                        dc.b $16 ;             ; ........................ ; $3c $3d $3e
                        dc.b $c0 ; ##......
                        dc.b $18 ; 
                        dc.b $0c ; ....##..
                        dc.b $19 ; 
                        dc.b $c0 ; ##......
                        dc.b $1b ; 
                        dc.b $0f ; ....####
                        dc.b $1c ; 
                        dc.b $c0 ; ##......
                        dc.b $1f ; 
                        dc.b $1f ; ...#####
                        dc.b $20 ; 
                        dc.b $80 ; #.......
                        dc.b $22 ; 
                        dc.b $19 ; ...##..#
                        dc.b $23 ; 
                        dc.b $80 ; #.......
                        dc.b $25 ; 
                        dc.b $19 ; ...##..#
                        dc.b $26 ; 
                        dc.b $80 ; #.......
                        dc.b $28 ; 
                        dc.b $19 ; ...##..#
                        dc.b $29 ; 
                        dc.b $80 ; #.......
                        dc.b $2b ; 
                        dc.b $1f ; ...#####
                        dc.b $2c ; 
                        dc.b $80 ; #.......
                        dc.b $2f ; 
                        dc.b $3f ; ..######
                        dc.b $32 ; 
                        dc.b $33 ; ..##..##
                        dc.b $35 ; 
                        dc.b $33 ; ..##..##
                        dc.b $38 ; 
                        dc.b $33 ; ..##..##
                        dc.b $3b ; 
                        dc.b $3f ; ..######
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SpriteData_Hill_02      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0a ; 
                        dc.b $3c ; ..####..
                        dc.b $0d ; 
                        dc.b $7e ; .######.
                        dc.b $10 ; 
                        dc.b $7e ; .######.
                        dc.b $13 ; 
                        dc.b $7e ; .######.
                        dc.b $16 ; 
                        dc.b $7e ; .######.
                        dc.b $19 ; 
                        dc.b $7e ; .######.
                        dc.b $1c ; 
                        dc.b $7e ; .######.
                        dc.b $1f ; 
                        dc.b $7e ; .######.
                        dc.b $22 ; 
                        dc.b $5a ; .#.##.#.
                        dc.b $25 ; 
                        dc.b $3c ; ..####..
                        dc.b $28 ; 
                        dc.b $3c ; ..####..
                        dc.b $2b ; 
                        dc.b $3c ; ..####..
                        dc.b $2e ; 
                        dc.b $3c ; ..####..
                        dc.b $31 ; 
                        dc.b $3c ; ..####..
                        dc.b $34 ; 
                        dc.b $3c ; ..####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_03      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0d ; 
                        dc.b $3c ; ..####..
                        dc.b $10 ; 
                        dc.b $7e ; .######.
                        dc.b $13 ; 
                        dc.b $7e ; .######.
                        dc.b $16 ; 
                        dc.b $7e ; .######.
                        dc.b $19 ; 
                        dc.b $7e ; .######.
                        dc.b $1c ; 
                        dc.b $7e ; .######.
                        dc.b $1f ; 
                        dc.b $7e ; .######.
                        dc.b $22 ; 
                        dc.b $5a ; .#.##.#.
                        dc.b $25 ; 
                        dc.b $3c ; ..####..
                        dc.b $28 ; 
                        dc.b $3c ; ..####..
                        dc.b $2b ; 
                        dc.b $3c ; ..####..
                        dc.b $2e ; 
                        dc.b $3c ; ..####..
                        dc.b $31 ; 
                        dc.b $3c ; ..####..
                        dc.b $34 ; 
                        dc.b $3c ; ..####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_04      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $10 ; 
                        dc.b $3c ; ..####..
                        dc.b $13 ; 
                        dc.b $7e ; .######.
                        dc.b $16 ; 
                        dc.b $7e ; .######.
                        dc.b $19 ; 
                        dc.b $7e ; .######.
                        dc.b $1c ; 
                        dc.b $7e ; .######.
                        dc.b $1f ; 
                        dc.b $7e ; .######.
                        dc.b $22 ; 
                        dc.b $7e ; .######.
                        dc.b $25 ; 
                        dc.b $5a ; .#.##.#.
                        dc.b $28 ; 
                        dc.b $3c ; ..####..
                        dc.b $2b ; 
                        dc.b $3c ; ..####..
                        dc.b $2e ; 
                        dc.b $3c ; ..####..
                        dc.b $31 ; 
                        dc.b $3c ; ..####..
                        dc.b $34 ; 
                        dc.b $3c ; ..####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_05      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $13 ; 
                        dc.b $3c ; ..####..
                        dc.b $16 ; 
                        dc.b $7e ; .######.
                        dc.b $19 ; 
                        dc.b $7e ; .######.
                        dc.b $1c ; 
                        dc.b $7e ; .######.
                        dc.b $1f ; 
                        dc.b $7e ; .######.
                        dc.b $22 ; 
                        dc.b $7e ; .######.
                        dc.b $25 ; 
                        dc.b $5a ; .#.##.#.
                        dc.b $28 ; 
                        dc.b $3c ; ..####..
                        dc.b $2b ; 
                        dc.b $3c ; ..####..
                        dc.b $2e ; 
                        dc.b $3c ; ..####..
                        dc.b $31 ; 
                        dc.b $3c ; ..####..
                        dc.b $34 ; 
                        dc.b $3c ; ..####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_06      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $16 ; 
                        dc.b $3c ; ..####..
                        dc.b $19 ; 
                        dc.b $7e ; .######.
                        dc.b $1c ; 
                        dc.b $7e ; .######.
                        dc.b $1f ; 
                        dc.b $7e ; .######.
                        dc.b $22 ; 
                        dc.b $7e ; .######.
                        dc.b $25 ; 
                        dc.b $7e ; .######.
                        dc.b $28 ; 
                        dc.b $5a ; .#.##.#.
                        dc.b $2b ; 
                        dc.b $3c ; ..####..
                        dc.b $2e ; 
                        dc.b $3c ; ..####..
                        dc.b $31 ; 
                        dc.b $3c ; ..####..
                        dc.b $34 ; 
                        dc.b $3c ; ..####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_07      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ; 
                        dc.b $3c ; ..####..
                        dc.b $1c ; 
                        dc.b $7e ; .######.
                        dc.b $1f ; 
                        dc.b $7e ; .######.
                        dc.b $22 ; 
                        dc.b $7e ; .######.
                        dc.b $25 ; 
                        dc.b $7e ; .######.
                        dc.b $28 ; 
                        dc.b $5a ; .#.##.#.
                        dc.b $2b ; 
                        dc.b $3c ; ..####..
                        dc.b $2e ; 
                        dc.b $3c ; ..####..
                        dc.b $31 ; 
                        dc.b $3c ; ..####..
                        dc.b $34 ; 
                        dc.b $3c ; ..####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_08      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1c ; 
                        dc.b $3c ; ..####..
                        dc.b $1f ; 
                        dc.b $7e ; .######.
                        dc.b $22 ; 
                        dc.b $7e ; .######.
                        dc.b $25 ; 
                        dc.b $7e ; .######.
                        dc.b $28 ; 
                        dc.b $7e ; .######.
                        dc.b $2b ; 
                        dc.b $5a ; .#.##.#.
                        dc.b $2e ; 
                        dc.b $3c ; ..####..
                        dc.b $31 ; 
                        dc.b $3c ; ..####..
                        dc.b $34 ; 
                        dc.b $3c ; ..####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_09      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1f ; 
                        dc.b $3c ; ..####..
                        dc.b $22 ; 
                        dc.b $7e ; .######.
                        dc.b $25 ; 
                        dc.b $7e ; .######.
                        dc.b $28 ; 
                        dc.b $7e ; .######.
                        dc.b $2b ; 
                        dc.b $5a ; .#.##.#.
                        dc.b $2e ; 
                        dc.b $3c ; ..####..
                        dc.b $31 ; 
                        dc.b $3c ; ..####..
                        dc.b $34 ; 
                        dc.b $3c ; ..####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_10      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $22 ; 
                        dc.b $3c ; ..####..
                        dc.b $25 ; 
                        dc.b $7e ; .######.
                        dc.b $28 ; 
                        dc.b $7e ; .######.
                        dc.b $2b ; 
                        dc.b $7e ; .######.
                        dc.b $2e ; 
                        dc.b $5a ; .#.##.#.
                        dc.b $31 ; 
                        dc.b $3c ; ..####..
                        dc.b $34 ; 
                        dc.b $3c ; ..####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_11      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $25 ; 
                        dc.b $3c ; ..####..
                        dc.b $28 ; 
                        dc.b $7e ; .######.
                        dc.b $2b ; 
                        dc.b $7e ; .######.
                        dc.b $2e ; 
                        dc.b $5a ; .#.##.#.
                        dc.b $31 ; 
                        dc.b $3c ; ..####..
                        dc.b $34 ; 
                        dc.b $3c ; ..####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_12      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $28 ; 
                        dc.b $3c ; ..####..
                        dc.b $2b ; 
                        dc.b $7e ; .######.
                        dc.b $2e ; 
                        dc.b $7e ; .######.
                        dc.b $31 ; 
                        dc.b $5a ; .#.##.#.
                        dc.b $34 ; 
                        dc.b $3c ; ..####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_13      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $2b ; 
                        dc.b $3c ; ..####..
                        dc.b $2e ; 
                        dc.b $7e ; .######.
                        dc.b $31 ; 
                        dc.b $5a ; .#.##.#.
                        dc.b $34 ; 
                        dc.b $3c ; ..####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_14      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $2e ; 
                        dc.b $3c ; ..####..
                        dc.b $31 ; 
                        dc.b $7e ; .######.
                        dc.b $34 ; 
                        dc.b $5a ; .#.##.#.
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_15      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $31 ; 
                        dc.b $3c ; ..####..
                        dc.b $34 ; 
                        dc.b $7e ; .######.
                        dc.b $37 ; 
                        dc.b $5a ; .#.##.#.
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_16      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $34 ; 
                        dc.b $3c ; ..####..
                        dc.b $37 ; 
                        dc.b $7e ; .######.
                        dc.b $3a ; 
                        dc.b $5a ; .#.##.#.
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_17      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $7e ; .######.
                        dc.b $3d ; 
                        dc.b $5a ; .#.##.#.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_18      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $21 ; 
                        dc.b $fc ; ######..
                        dc.b $24 ; 
                        dc.b $ff ; ########
                        dc.b $25 ; 
                        dc.b $ff ; ########
                        dc.b $27 ; 
                        dc.b $03 ; ......##
                        dc.b $28 ; 
                        dc.b $ff ; ########
                        dc.b $2b ; 
                        dc.b $03 ; ......##
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_19      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1e ; 
                        dc.b $f8 ; #####...
                        dc.b $21 ; 
                        dc.b $ff ; ########
                        dc.b $22 ; 
                        dc.b $c0 ; ##......
                        dc.b $24 ; 
                        dc.b $07 ; .....###
                        dc.b $25 ; 
                        dc.b $ff ; ########
                        dc.b $28 ; 
                        dc.b $3f ; ..######
                        dc.b $2b ; 
                        dc.b $03 ; ......##
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_20      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1b ; 
                        dc.b $78 ; .####...
                        dc.b $1e ; 
                        dc.b $7f ; .#######
                        dc.b $1f ; 
                        dc.b $80 ; #.......
                        dc.b $21 ; 
                        dc.b $07 ; .....###
                        dc.b $22 ; 
                        dc.b $f8 ; #####...
                        dc.b $25 ; 
                        dc.b $7f ; .#######
                        dc.b $26 ; 
                        dc.b $80 ; #.......
                        dc.b $28 ; 
                        dc.b $07 ; .....###
                        dc.b $29 ; 
                        dc.b $80 ; #.......
                        dc.b $2b ; 
                        dc.b $01 ; .......#
                        dc.b $2c ; 
                        dc.b $80 ; #.......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_21      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $18 ; 
                        dc.b $38 ; ..###...
                        dc.b $1b ; 
                        dc.b $3f ; ..######
                        dc.b $1c ; 
                        dc.b $80 ; #.......
                        dc.b $1e ; 
                        dc.b $07 ; .....###
                        dc.b $1f ; 
                        dc.b $f8 ; #####...
                        dc.b $22 ; 
                        dc.b $7f ; .#######
                        dc.b $23 ; 
                        dc.b $80 ; #.......
                        dc.b $25 ; 
                        dc.b $07 ; .....###
                        dc.b $26 ; 
                        dc.b $80 ; #.......
                        dc.b $28 ; 
                        dc.b $01 ; .......#
                        dc.b $29 ; 
                        dc.b $80 ; #.......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_22      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $15 ; 
                        dc.b $0c ; ....##..
                        dc.b $18 ; 
                        dc.b $0f ; ....####
                        dc.b $19 ; 
                        dc.b $80 ; #.......
                        dc.b $1b ; 
                        dc.b $03 ; ......##
                        dc.b $1c ; 
                        dc.b $f0 ; ####....
                        dc.b $1f ; 
                        dc.b $7e ; .######.
                        dc.b $22 ; 
                        dc.b $0f ; ....####
                        dc.b $23 ; 
                        dc.b $c0 ; ##......
                        dc.b $25 ; 
                        dc.b $01 ; .......#
                        dc.b $26 ; 
                        dc.b $c0 ; ##......
                        dc.b $29 ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_23      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $12 ; 
                        dc.b $03 ; ......##
                        dc.b $15 ; 
                        dc.b $03 ; ......##
                        dc.b $16 ; 
                        dc.b $c0 ; ##......
                        dc.b $18 ; 
                        dc.b $01 ; .......#
                        dc.b $19 ; 
                        dc.b $f0 ; ####....
                        dc.b $1c ; 
                        dc.b $7c ; .#####..
                        dc.b $1f ; 
                        dc.b $1f ; ...#####
                        dc.b $22 ; 
                        dc.b $07 ; .....###
                        dc.b $23 ; 
                        dc.b $c0 ; ##......
                        dc.b $25 ; 
                        dc.b $01 ; .......#
                        dc.b $26 ; 
                        dc.b $c0 ; ##......
                        dc.b $29 ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_24      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $10 ; 
                        dc.b $c0 ; ##......
                        dc.b $13 ; 
                        dc.b $e0 ; ###.....
                        dc.b $16 ; 
                        dc.b $78 ; .####...
                        dc.b $19 ; 
                        dc.b $3c ; ..####..
                        dc.b $1c ; 
                        dc.b $0f ; ....####
                        dc.b $1f ; 
                        dc.b $07 ; .....###
                        dc.b $20 ; 
                        dc.b $80 ; #.......
                        dc.b $22 ; 
                        dc.b $03 ; ......##
                        dc.b $23 ; 
                        dc.b $e0 ; ###.....
                        dc.b $26 ; 
                        dc.b $e0 ; ###.....
                        dc.b $29 ; 
                        dc.b $60 ; .##.....
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_25      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0d ; 
                        dc.b $30 ; ..##....
                        dc.b $10 ; 
                        dc.b $38 ; ..###...
                        dc.b $13 ; 
                        dc.b $1c ; ...###..
                        dc.b $16 ; 
                        dc.b $0e ; ....###.
                        dc.b $19 ; 
                        dc.b $07 ; .....###
                        dc.b $1c ; 
                        dc.b $03 ; ......##
                        dc.b $1d ; 
                        dc.b $80 ; #.......
                        dc.b $1f ; 
                        dc.b $01 ; .......#
                        dc.b $20 ; 
                        dc.b $e0 ; ###.....
                        dc.b $23 ; 
                        dc.b $e0 ; ###.....
                        dc.b $26 ; 
                        dc.b $60 ; .##.....
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_26      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0a ; 
                        dc.b $0c ; ....##..
                        dc.b $0d ; 
                        dc.b $0e ; ....###.
                        dc.b $10 ; 
                        dc.b $07 ; .....###
                        dc.b $13 ; 
                        dc.b $03 ; ......##
                        dc.b $16 ; 
                        dc.b $03 ; ......##
                        dc.b $17 ; 
                        dc.b $80 ; #.......
                        dc.b $19 ; 
                        dc.b $01 ; .......#
                        dc.b $1a ; 
                        dc.b $c0 ; ##......
                        dc.b $1d ; 
                        dc.b $e0 ; ###.....
                        dc.b $20 ; 
                        dc.b $70 ; .###....
                        dc.b $23 ; 
                        dc.b $70 ; .###....
                        dc.b $26 ; 
                        dc.b $30 ; ..##....
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_27      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $07 ; 
                        dc.b $03 ; ......##
                        dc.b $0a ; 
                        dc.b $03 ; ......##
                        dc.b $0d ; 
                        dc.b $01 ; .......#
                        dc.b $0e ; 
                        dc.b $80 ; #.......
                        dc.b $10 ; 
                        dc.b $01 ; .......#
                        dc.b $11 ; 
                        dc.b $80 ; #.......
                        dc.b $14 ; 
                        dc.b $c0 ; ##......
                        dc.b $17 ; 
                        dc.b $60 ; .##.....
                        dc.b $1a ; 
                        dc.b $60 ; .##.....
                        dc.b $1d ; 
                        dc.b $30 ; ..##....
                        dc.b $20 ; 
                        dc.b $38 ; ..###...
                        dc.b $23 ; 
                        dc.b $18 ; ...##...
                        dc.b $26 ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_28      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $08 ; 
                        dc.b $60 ; .##.....
                        dc.b $0b ; 
                        dc.b $60 ; .##.....
                        dc.b $0e ; 
                        dc.b $70 ; .###....
                        dc.b $11 ; 
                        dc.b $30 ; ..##....
                        dc.b $14 ; 
                        dc.b $30 ; ..##....
                        dc.b $17 ; 
                        dc.b $18 ; ...##...
                        dc.b $1a ; 
                        dc.b $18 ; ...##...
                        dc.b $1d ; 
                        dc.b $18 ; ...##...
                        dc.b $20 ; 
                        dc.b $0c ; ....##..
                        dc.b $23 ; 
                        dc.b $0c ; ....##..
                        dc.b $26 ; 
                        dc.b $0c ; ....##..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_29      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $05 ; 
                        dc.b $18 ; ...##...
                        dc.b $08 ; 
                        dc.b $18 ; ...##...
                        dc.b $0b ; 
                        dc.b $18 ; ...##...
                        dc.b $0e ; 
                        dc.b $18 ; ...##...
                        dc.b $11 ; 
                        dc.b $0c ; ....##..
                        dc.b $14 ; 
                        dc.b $0c ; ....##..
                        dc.b $17 ; 
                        dc.b $0c ; ....##..
                        dc.b $1a ; 
                        dc.b $0c ; ....##..
                        dc.b $1d ; 
                        dc.b $06 ; .....##.
                        dc.b $20 ; 
                        dc.b $06 ; .....##.
                        dc.b $23 ; 
                        dc.b $06 ; .....##.
                        dc.b $26 ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_30      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $05 ; 
                        dc.b $06 ; .....##.
                        dc.b $08 ; 
                        dc.b $06 ; .....##.
                        dc.b $0b ; 
                        dc.b $06 ; .....##.
                        dc.b $0e ; 
                        dc.b $06 ; .....##.
                        dc.b $11 ; 
                        dc.b $06 ; .....##.
                        dc.b $14 ; 
                        dc.b $06 ; .....##.
                        dc.b $17 ; 
                        dc.b $06 ; .....##.
                        dc.b $1a ; 
                        dc.b $06 ; .....##.
                        dc.b $1d ; 
                        dc.b $06 ; .....##.
                        dc.b $20 ; 
                        dc.b $06 ; .....##.
                        dc.b $23 ; 
                        dc.b $06 ; .....##.
                        dc.b $26 ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_31      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $08 ; 
                        dc.b $06 ; .....##.
                        dc.b $0b ; 
                        dc.b $06 ; .....##.
                        dc.b $0e ; 
                        dc.b $06 ; .....##.
                        dc.b $11 ; 
                        dc.b $06 ; .....##.
                        dc.b $14 ; 
                        dc.b $06 ; .....##.
                        dc.b $17 ; 
                        dc.b $06 ; .....##.
                        dc.b $1a ; 
                        dc.b $06 ; .....##.
                        dc.b $1d ; 
                        dc.b $06 ; .....##.
                        dc.b $20 ; 
                        dc.b $06 ; .....##.
                        dc.b $23 ; 
                        dc.b $06 ; .....##.
                        dc.b $26 ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_32      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0b ; 
                        dc.b $06 ; .....##.
                        dc.b $0e ; 
                        dc.b $06 ; .....##.
                        dc.b $11 ; 
                        dc.b $06 ; .....##.
                        dc.b $14 ; 
                        dc.b $06 ; .....##.
                        dc.b $17 ; 
                        dc.b $06 ; .....##.
                        dc.b $1a ; 
                        dc.b $06 ; .....##.
                        dc.b $1d ; 
                        dc.b $06 ; .....##.
                        dc.b $20 ; 
                        dc.b $06 ; .....##.
                        dc.b $23 ; 
                        dc.b $06 ; .....##.
                        dc.b $26 ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_33      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0e ; 
                        dc.b $06 ; .....##.
                        dc.b $11 ; 
                        dc.b $06 ; .....##.
                        dc.b $14 ; 
                        dc.b $06 ; .....##.
                        dc.b $17 ; 
                        dc.b $06 ; .....##.
                        dc.b $1a ; 
                        dc.b $06 ; .....##.
                        dc.b $1d ; 
                        dc.b $06 ; .....##.
                        dc.b $20 ; 
                        dc.b $06 ; .....##.
                        dc.b $23 ; 
                        dc.b $06 ; .....##.
                        dc.b $26 ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_34      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $11 ; 
                        dc.b $06 ; .....##.
                        dc.b $14 ; 
                        dc.b $06 ; .....##.
                        dc.b $17 ; 
                        dc.b $06 ; .....##.
                        dc.b $1a ; 
                        dc.b $06 ; .....##.
                        dc.b $1d ; 
                        dc.b $06 ; .....##.
                        dc.b $20 ; 
                        dc.b $06 ; .....##.
                        dc.b $23 ; 
                        dc.b $06 ; .....##.
                        dc.b $26 ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_35      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $14 ; 
                        dc.b $06 ; .....##.
                        dc.b $17 ; 
                        dc.b $06 ; .....##.
                        dc.b $1a ; 
                        dc.b $06 ; .....##.
                        dc.b $1d ; 
                        dc.b $06 ; .....##.
                        dc.b $20 ; 
                        dc.b $06 ; .....##.
                        dc.b $23 ; 
                        dc.b $06 ; .....##.
                        dc.b $26 ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_36      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $17 ; 
                        dc.b $06 ; .....##.
                        dc.b $1a ; 
                        dc.b $06 ; .....##.
                        dc.b $1d ; 
                        dc.b $06 ; .....##.
                        dc.b $20 ; 
                        dc.b $06 ; .....##.
                        dc.b $23 ; 
                        dc.b $06 ; .....##.
                        dc.b $26 ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_37      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1a ; 
                        dc.b $06 ; .....##.
                        dc.b $1d ; 
                        dc.b $06 ; .....##.
                        dc.b $20 ; 
                        dc.b $06 ; .....##.
                        dc.b $23 ; 
                        dc.b $06 ; .....##.
                        dc.b $26 ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_38      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1d ; 
                        dc.b $06 ; .....##.
                        dc.b $20 ; 
                        dc.b $06 ; .....##.
                        dc.b $23 ; 
                        dc.b $06 ; .....##.
                        dc.b $26 ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_39      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $20 ; 
                        dc.b $06 ; .....##.
                        dc.b $23 ; 
                        dc.b $06 ; .....##.
                        dc.b $26 ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_40      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ; 
                        dc.b $7e ; .######.
                        dc.b $1c ; 
                        dc.b $7e ; .######.
                        dc.b $1f ; 
                        dc.b $7e ; .######.
                        dc.b $22 ; 
                        dc.b $7e ; .######.
                        dc.b $25 ; 
                        dc.b $7e ; .######.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_41      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0d ; 
                        dc.b $0c ; ....##..
                        dc.b $10 ; 
                        dc.b $7e ; .######.
                        dc.b $12 ; 
                        dc.b $03 ; ......##
                        dc.b $13 ; 
                        dc.b $3f ; ..######
                        dc.b $14 ; 
                        dc.b $30 ; ..##....
                        dc.b $15 ; 
                        dc.b $01 ; .......#
                        dc.b $16 ; 
                        dc.b $ff ; ########
                        dc.b $17 ; 
                        dc.b $e0 ; ###.....
                        dc.b $18 ; 
                        dc.b $01 ; .......#
                        dc.b $19 ; 
                        dc.b $ff ; ########
                        dc.b $1a ; 
                        dc.b $c0 ; ##......
                        dc.b $1b ; 
                        dc.b $0f ; ....####
                        dc.b $1c ; 
                        dc.b $ff ; ########
                        dc.b $1d ; 
                        dc.b $e0 ; ###.....
                        dc.b $1e ; 
                        dc.b $0f ; ....####
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $f0 ; ####....
                        dc.b $21 ; 
                        dc.b $03 ; ......##
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $23 ; 
                        dc.b $80 ; #.......
                        dc.b $25 ; 
                        dc.b $ff ; ########
                        dc.b $26 ; 
                        dc.b $c0 ; ##......
                        dc.b $27 ; 
                        dc.b $01 ; .......#
                        dc.b $28 ; 
                        dc.b $ff ; ########
                        dc.b $2b ; 
                        dc.b $e7 ; ###..###
                        dc.b $2c ; 
                        dc.b $80 ; #.......
                        dc.b $2e ; 
                        dc.b $ce ; ##..###.
                        dc.b $31 ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_42      dc.b $00 ; <flag: full sprite data>
                        
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $40, $00 ; .........#..............
                        dc.b $00, $60, $00 ; .........##.............
                        dc.b $00, $60, $c0 ; .........##.....##......
                        dc.b $11, $db, $98 ; ...#...###.##.###..##...
                        dc.b $39, $bf, $7c ; ..###..##.######.#####..
                        dc.b $1f, $f9, $d8 ; ...##########..###.##...
                        dc.b $06, $7f, $f0 ; .....##..###########....
                        dc.b $1f, $df, $78 ; ...#######.#####.####...
                        dc.b $7b, $f7, $f0 ; .####.######.#######....
                        dc.b $0e, $fe, $fe ; ....###.#######.#######.
                        dc.b $0f, $ff, $9c ; ....#############..###..
                        dc.b $3b, $ff, $f8 ; ..###.###############...
                        dc.b $07, $ff, $ef ; .....##############.####
                        dc.b $1f, $ff, $fc ; ...###################..
                        dc.b $7f, $ff, $f0 ; .###################....
                        dc.b $3f, $ff, $f8 ; ..###################...
                        dc.b $ff, $ff, $fe ; #######################.
                        dc.b $7f, $ff, $fe ; .######################.
                        dc.b $ff, $ff, $ff ; ########################
                        
SpriteData_Hill_43      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ; 
                        dc.b $0a ; ....#.#.
                        dc.b $1c ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $1d ; 
                        dc.b $80 ; #.......
                        dc.b $1f ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $22 ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $25 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $28 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $29 ; 
                        dc.b $80 ; #.......
                        dc.b $2b ; 
                        dc.b $af ; #.#.####
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_44      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ; 
                        dc.b $88 ; #...#...
                        dc.b $1c ; 
                        dc.b $8b ; #...#.##
                        dc.b $1f ; 
                        dc.b $ab ; #.#.#.##
                        dc.b $22 ; 
                        dc.b $ab ; #.#.#.##
                        dc.b $25 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $28 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $2b ; 
                        dc.b $0a ; ....#.#.
                        dc.b $2e ; 
                        dc.b $0a ; ....#.#.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_45      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ; 
                        dc.b $fa ; #####.#.
                        dc.b $1b ; 
                        dc.b $02 ; ......#.
                        dc.b $1c ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $1f ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $22 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $25 ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $27 ; 
                        dc.b $02 ; ......#.
                        dc.b $28 ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $2b ; 
                        dc.b $a0 ; #.#.....
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_46      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ; 
                        dc.b $a0 ; #.#.....
                        dc.b $1c ; 
                        dc.b $a0 ; #.#.....
                        dc.b $1f ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $22 ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $25 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $28 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $2b ; 
                        dc.b $e2 ; ###...#.
                        dc.b $2e ; 
                        dc.b $22 ; ..#...#.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_47      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $1c ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $1e ; 
                        dc.b $02 ; ......#.
                        dc.b $1f ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $20 ; 
                        dc.b $80 ; #.......
                        dc.b $22 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $25 ; 
                        dc.b $28 ; ..#.#...
                        dc.b $28 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $2a ; 
                        dc.b $02 ; ......#.
                        dc.b $2b ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $2c ; 
                        dc.b $80 ; #.......
                        dc.b $2e ; 
                        dc.b $eb ; ###.#.##
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_48      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ; 
                        dc.b $88 ; #...#...
                        dc.b $1b ; 
                        dc.b $02 ; ......#.
                        dc.b $1c ; 
                        dc.b $8b ; #...#.##
                        dc.b $1e ; 
                        dc.b $02 ; ......#.
                        dc.b $1f ; 
                        dc.b $ab ; #.#.#.##
                        dc.b $21 ; 
                        dc.b $02 ; ......#.
                        dc.b $22 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $24 ; 
                        dc.b $02 ; ......#.
                        dc.b $25 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $27 ; 
                        dc.b $02 ; ......#.
                        dc.b $28 ; 
                        dc.b $ab ; #.#.#.##
                        dc.b $2a ; 
                        dc.b $02 ; ......#.
                        dc.b $2b ; 
                        dc.b $8b ; #...#.##
                        dc.b $2e ; 
                        dc.b $88 ; #...#...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_49      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ; 
                        dc.b $eb ; ###.#.##
                        dc.b $1b ; 
                        dc.b $02 ; ......#.
                        dc.b $1c ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $1d ; 
                        dc.b $80 ; #.......
                        dc.b $1f ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $22 ; 
                        dc.b $28 ; ..#.#...
                        dc.b $25 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $27 ; 
                        dc.b $02 ; ......#.
                        dc.b $28 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $29 ; 
                        dc.b $80 ; #.......
                        dc.b $2b ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $2e ; 
                        dc.b $aa ; #.#.#.#.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_50      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ; 
                        dc.b $88 ; #...#...
                        dc.b $1b ; 
                        dc.b $03 ; ......##
                        dc.b $1c ; 
                        dc.b $8a ; #...#.#.
                        dc.b $1e ; 
                        dc.b $03 ; ......##
                        dc.b $1f ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $21 ; 
                        dc.b $02 ; ......#.
                        dc.b $22 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $24 ; 
                        dc.b $02 ; ......#.
                        dc.b $25 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $27 ; 
                        dc.b $03 ; ......##
                        dc.b $28 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $2a ; 
                        dc.b $03 ; ......##
                        dc.b $2b ; 
                        dc.b $8a ; #...#.#.
                        dc.b $2e ; 
                        dc.b $88 ; #...#...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_51      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ; 
                        dc.b $80 ; #.......
                        dc.b $1c ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $1e ; 
                        dc.b $02 ; ......#.
                        dc.b $1f ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $22 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $23 ; 
                        dc.b $80 ; #.......
                        dc.b $25 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $26 ; 
                        dc.b $80 ; #.......
                        dc.b $28 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $29 ; 
                        dc.b $80 ; #.......
                        dc.b $2a ; 
                        dc.b $02 ; ......#.
                        dc.b $2b ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $2c ; 
                        dc.b $80 ; #.......
                        dc.b $2e ; 
                        dc.b $fe ; #######.
                        dc.b $2f ; 
                        dc.b $80 ; #.......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_52      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ; 
                        dc.b $22 ; ..#...#.
                        dc.b $1c ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $1d ; 
                        dc.b $80 ; #.......
                        dc.b $1f ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $20 ; 
                        dc.b $80 ; #.......
                        dc.b $22 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $25 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $28 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $2b ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $2e ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $31 ; 
                        dc.b $a0 ; #.#.....
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_53      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $18 ; 
                        dc.b $02 ; ......#.
                        dc.b $19 ; 
                        dc.b $bf ; #.######
                        dc.b $1b ; 
                        dc.b $02 ; ......#.
                        dc.b $1c ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $1d ; 
                        dc.b $80 ; #.......
                        dc.b $1e ; 
                        dc.b $02 ; ......#.
                        dc.b $1f ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $21 ; 
                        dc.b $02 ; ......#.
                        dc.b $22 ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $25 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $28 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $29 ; 
                        dc.b $80 ; #.......
                        dc.b $2b ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $2e ; 
                        dc.b $02 ; ......#.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_54      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ; 
                        dc.b $02 ; ......#.
                        dc.b $1a ; 
                        dc.b $80 ; #.......
                        dc.b $1c ; 
                        dc.b $0a ; ....#.#.
                        dc.b $1d ; 
                        dc.b $80 ; #.......
                        dc.b $1f ; 
                        dc.b $0a ; ....#.#.
                        dc.b $20 ; 
                        dc.b $80 ; #.......
                        dc.b $22 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $23 ; 
                        dc.b $c0 ; ##......
                        dc.b $25 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $26 ; 
                        dc.b $c0 ; ##......
                        dc.b $28 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $29 ; 
                        dc.b $c0 ; ##......
                        dc.b $2b ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $2c ; 
                        dc.b $c0 ; ##......
                        dc.b $2e ; 
                        dc.b $a2 ; #.#...#.
                        dc.b $2f ; 
                        dc.b $c0 ; ##......
                        dc.b $31 ; 
                        dc.b $22 ; ..#...#.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_55      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $18 ; 
                        dc.b $03 ; ......##
                        dc.b $19 ; 
                        dc.b $fa ; #####.#.
                        dc.b $1a ; 
                        dc.b $a0 ; #.#.....
                        dc.b $1b ; 
                        dc.b $0a ; ....#.#.
                        dc.b $1c ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $1d ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $1e ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $1f ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $20 ; 
                        dc.b $a0 ; #.#.....
                        dc.b $21 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $22 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $23 ; 
                        dc.b $80 ; #.......
                        dc.b $24 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $25 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $26 ; 
                        dc.b $a0 ; #.#.....
                        dc.b $27 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $28 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $29 ; 
                        dc.b $fc ; ######..
                        dc.b $2a ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $2b ; 
                        dc.b $af ; #.#.####
                        dc.b $2c ; 
                        dc.b $f0 ; ####....
                        dc.b $2d ; 
                        dc.b $2f ; ..#.####
                        dc.b $2e ; 
                        dc.b $ff ; ########
                        dc.b $2f ; 
                        dc.b $f0 ; ####....
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_56      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0d ; 
                        dc.b $23 ; ..#...##
                        dc.b $10 ; 
                        dc.b $a3 ; #.#...##
                        dc.b $11 ; 
                        dc.b $c0 ; ##......
                        dc.b $13 ; 
                        dc.b $ab ; #.#.#.##
                        dc.b $14 ; 
                        dc.b $c0 ; ##......
                        dc.b $16 ; 
                        dc.b $ab ; #.#.#.##
                        dc.b $17 ; 
                        dc.b $c0 ; ##......
                        dc.b $19 ; 
                        dc.b $ab ; #.#.#.##
                        dc.b $1a ; 
                        dc.b $c0 ; ##......
                        dc.b $1c ; 
                        dc.b $ab ; #.#.#.##
                        dc.b $1d ; 
                        dc.b $c0 ; ##......
                        dc.b $1f ; 
                        dc.b $ab ; #.#.#.##
                        dc.b $20 ; 
                        dc.b $c0 ; ##......
                        dc.b $22 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $23 ; 
                        dc.b $c0 ; ##......
                        dc.b $25 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $26 ; 
                        dc.b $c0 ; ##......
                        dc.b $28 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $29 ; 
                        dc.b $c0 ; ##......
                        dc.b $2b ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $2c ; 
                        dc.b $c0 ; ##......
                        dc.b $2e ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $2f ; 
                        dc.b $c0 ; ##......
                        dc.b $31 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $32 ; 
                        dc.b $c0 ; ##......
                        dc.b $34 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $35 ; 
                        dc.b $c0 ; ##......
                        dc.b $37 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $38 ; 
                        dc.b $80 ; #.......
                        dc.b $3a ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $3b ; 
                        dc.b $80 ; #.......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_57      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $18 ; 
                        dc.b $0f ; ....####
                        dc.b $19 ; 
                        dc.b $ff ; ########
                        dc.b $1a ; 
                        dc.b $f8 ; #####...
                        dc.b $1b ; 
                        dc.b $0f ; ....####
                        dc.b $1c ; 
                        dc.b $fa ; #####.#.
                        dc.b $1d ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $1e ; 
                        dc.b $3f ; ..######
                        dc.b $1f ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $20 ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $21 ; 
                        dc.b $0a ; ....#.#.
                        dc.b $22 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $23 ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $24 ; 
                        dc.b $02 ; ......#.
                        dc.b $25 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $26 ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $27 ; 
                        dc.b $0a ; ....#.#.
                        dc.b $28 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $29 ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $2a ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $2b ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $2c ; 
                        dc.b $a0 ; #.#.....
                        dc.b $2d ; 
                        dc.b $0a ; ....#.#.
                        dc.b $2e ; 
                        dc.b $af ; #.#.####
                        dc.b $2f ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_58      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $10 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $13 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $16 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $19 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $1a ; 
                        dc.b $c0 ; ##......
                        dc.b $1c ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $1d ; 
                        dc.b $c0 ; ##......
                        dc.b $1f ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $20 ; 
                        dc.b $c0 ; ##......
                        dc.b $22 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $23 ; 
                        dc.b $c0 ; ##......
                        dc.b $25 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $26 ; 
                        dc.b $80 ; #.......
                        dc.b $28 ; 
                        dc.b $fa ; #####.#.
                        dc.b $29 ; 
                        dc.b $80 ; #.......
                        dc.b $2b ; 
                        dc.b $fa ; #####.#.
                        dc.b $2c ; 
                        dc.b $80 ; #.......
                        dc.b $2e ; 
                        dc.b $fa ; #####.#.
                        dc.b $2f ; 
                        dc.b $80 ; #.......
                        dc.b $31 ; 
                        dc.b $fa ; #####.#.
                        dc.b $32 ; 
                        dc.b $80 ; #.......
                        dc.b $34 ; 
                        dc.b $fa ; #####.#.
                        dc.b $35 ; 
                        dc.b $80 ; #.......
                        dc.b $37 ; 
                        dc.b $f2 ; ####..#.
                        dc.b $38 ; 
                        dc.b $80 ; #.......
                        dc.b $3a ; 
                        dc.b $32 ; ..##..#.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_59      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $18 ; 
                        dc.b $0a ; ....#.#.
                        dc.b $19 ; 
                        dc.b $ab ; #.#.#.##
                        dc.b $1a ; 
                        dc.b $c0 ; ##......
                        dc.b $1b ; 
                        dc.b $02 ; ......#.
                        dc.b $1c ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $1d ; 
                        dc.b $a0 ; #.#.....
                        dc.b $1e ; 
                        dc.b $0a ; ....#.#.
                        dc.b $1f ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $20 ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $21 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $22 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $23 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $24 ; 
                        dc.b $0a ; ....#.#.
                        dc.b $25 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $26 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $27 ; 
                        dc.b $03 ; ......##
                        dc.b $28 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $29 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $2a ; 
                        dc.b $0f ; ....####
                        dc.b $2b ; 
                        dc.b $fe ; #######.
                        dc.b $2c ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $2d ; 
                        dc.b $0f ; ....####
                        dc.b $2e ; 
                        dc.b $ff ; ########
                        dc.b $2f ; 
                        dc.b $fe ; #######.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_60      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0d ; 
                        dc.b $08 ; ....#...
                        dc.b $10 ; 
                        dc.b $c8 ; ##..#...
                        dc.b $11 ; 
                        dc.b $80 ; #.......
                        dc.b $13 ; 
                        dc.b $fa ; #####.#.
                        dc.b $14 ; 
                        dc.b $80 ; #.......
                        dc.b $16 ; 
                        dc.b $fa ; #####.#.
                        dc.b $17 ; 
                        dc.b $80 ; #.......
                        dc.b $19 ; 
                        dc.b $fa ; #####.#.
                        dc.b $1a ; 
                        dc.b $80 ; #.......
                        dc.b $1c ; 
                        dc.b $fa ; #####.#.
                        dc.b $1d ; 
                        dc.b $80 ; #.......
                        dc.b $1f ; 
                        dc.b $fa ; #####.#.
                        dc.b $20 ; 
                        dc.b $80 ; #.......
                        dc.b $22 ; 
                        dc.b $fa ; #####.#.
                        dc.b $23 ; 
                        dc.b $80 ; #.......
                        dc.b $25 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $26 ; 
                        dc.b $80 ; #.......
                        dc.b $28 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $29 ; 
                        dc.b $c0 ; ##......
                        dc.b $2b ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $2c ; 
                        dc.b $c0 ; ##......
                        dc.b $2e ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $2f ; 
                        dc.b $c0 ; ##......
                        dc.b $31 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $34 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $37 ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $3a ; 
                        dc.b $a8 ; #.#.#...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_61      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $18 ; 
                        dc.b $2f ; ..#.####
                        dc.b $19 ; 
                        dc.b $ff ; ########
                        dc.b $1a ; 
                        dc.b $fc ; ######..
                        dc.b $1b ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $1c ; 
                        dc.b $af ; #.#.####
                        dc.b $1d ; 
                        dc.b $fc ; ######..
                        dc.b $1e ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $1f ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $20 ; 
                        dc.b $f0 ; ####....
                        dc.b $21 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $22 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $23 ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $24 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $25 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $26 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $27 ; 
                        dc.b $0a ; ....#.#.
                        dc.b $28 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $29 ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $2a ; 
                        dc.b $02 ; ......#.
                        dc.b $2b ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $2c ; 
                        dc.b $a0 ; #.#.....
                        dc.b $2e ; 
                        dc.b $fa ; #####.#.
                        dc.b $2f ; 
                        dc.b $a8 ; #.#.#...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_62      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0d ; 
                        dc.b $0a ; ....#.#.
                        dc.b $0e ; 
                        dc.b $80 ; #.......
                        dc.b $10 ; 
                        dc.b $0a ; ....#.#.
                        dc.b $11 ; 
                        dc.b $80 ; #.......
                        dc.b $13 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $14 ; 
                        dc.b $c0 ; ##......
                        dc.b $16 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $17 ; 
                        dc.b $c0 ; ##......
                        dc.b $19 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $1a ; 
                        dc.b $c0 ; ##......
                        dc.b $1c ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $1d ; 
                        dc.b $c0 ; ##......
                        dc.b $1f ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $20 ; 
                        dc.b $c0 ; ##......
                        dc.b $22 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $23 ; 
                        dc.b $c0 ; ##......
                        dc.b $25 ; 
                        dc.b $ab ; #.#.#.##
                        dc.b $26 ; 
                        dc.b $c0 ; ##......
                        dc.b $28 ; 
                        dc.b $ab ; #.#.#.##
                        dc.b $29 ; 
                        dc.b $c0 ; ##......
                        dc.b $2b ; 
                        dc.b $ab ; #.#.#.##
                        dc.b $2c ; 
                        dc.b $c0 ; ##......
                        dc.b $2e ; 
                        dc.b $ab ; #.#.#.##
                        dc.b $2f ; 
                        dc.b $c0 ; ##......
                        dc.b $31 ; 
                        dc.b $ab ; #.#.#.##
                        dc.b $32 ; 
                        dc.b $c0 ; ##......
                        dc.b $34 ; 
                        dc.b $ab ; #.#.#.##
                        dc.b $35 ; 
                        dc.b $c0 ; ##......
                        dc.b $37 ; 
                        dc.b $88 ; #...#...
                        dc.b $38 ; 
                        dc.b $c0 ; ##......
                        dc.b $3a ; 
                        dc.b $08 ; ....#...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_63      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0f ; 
                        dc.b $06 ; .....##.
                        dc.b $12 ; 
                        dc.b $1e ; ...####.
                        dc.b $15 ; 
                        dc.b $7f ; .#######
                        dc.b $18 ; 
                        dc.b $ff ; ########
                        dc.b $1b ; 
                        dc.b $fc ; ######..
                        dc.b $1c ; 
                        dc.b $80 ; #.......
                        dc.b $1e ; 
                        dc.b $70 ; .###....
                        dc.b $1f ; 
                        dc.b $80 ; #.......
                        dc.b $21 ; 
                        dc.b $40 ; .#......
                        dc.b $22 ; 
                        dc.b $40 ; .#......
                        dc.b $25 ; 
                        dc.b $40 ; .#......
                        dc.b $28 ; 
                        dc.b $60 ; .##.....
                        dc.b $2b ; 
                        dc.b $30 ; ..##....
                        dc.b $2e ; 
                        dc.b $10 ; ...#....
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_64      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0f ; 
                        dc.b $0f ; ....####
                        dc.b $10 ; 
                        dc.b $f0 ; ####....
                        dc.b $12 ; 
                        dc.b $0f ; ....####
                        dc.b $13 ; 
                        dc.b $f0 ; ####....
                        dc.b $15 ; 
                        dc.b $0f ; ....####
                        dc.b $16 ; 
                        dc.b $f0 ; ####....
                        dc.b $18 ; 
                        dc.b $0f ; ....####
                        dc.b $19 ; 
                        dc.b $f0 ; ####....
                        dc.b $1c ; 
                        dc.b $10 ; ...#....
                        dc.b $1f ; 
                        dc.b $10 ; ...#....
                        dc.b $22 ; 
                        dc.b $10 ; ...#....
                        dc.b $25 ; 
                        dc.b $18 ; ...##...
                        dc.b $28 ; 
                        dc.b $18 ; ...##...
                        dc.b $2b ; 
                        dc.b $08 ; ....#...
                        dc.b $2e ; 
                        dc.b $08 ; ....#...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_65      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0a ; 
                        dc.b $06 ; .....##.
                        dc.b $0d ; 
                        dc.b $0f ; ....####
                        dc.b $0e ; 
                        dc.b $80 ; #.......
                        dc.b $10 ; 
                        dc.b $1f ; ...#####
                        dc.b $11 ; 
                        dc.b $e0 ; ###.....
                        dc.b $13 ; 
                        dc.b $1f ; ...#####
                        dc.b $14 ; 
                        dc.b $f8 ; #####...
                        dc.b $16 ; 
                        dc.b $07 ; .....###
                        dc.b $17 ; 
                        dc.b $f0 ; ####....
                        dc.b $19 ; 
                        dc.b $01 ; .......#
                        dc.b $1a ; 
                        dc.b $e0 ; ###.....
                        dc.b $1d ; 
                        dc.b $40 ; .#......
                        dc.b $20 ; 
                        dc.b $80 ; #.......
                        dc.b $22 ; 
                        dc.b $01 ; .......#
                        dc.b $25 ; 
                        dc.b $06 ; .....##.
                        dc.b $28 ; 
                        dc.b $06 ; .....##.
                        dc.b $2b ; 
                        dc.b $0c ; ....##..
                        dc.b $2e ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_66      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $11 ; 
                        dc.b $c0 ; ##......
                        dc.b $14 ; 
                        dc.b $f0 ; ####....
                        dc.b $16 ; 
                        dc.b $01 ; .......#
                        dc.b $17 ; 
                        dc.b $fc ; ######..
                        dc.b $19 ; 
                        dc.b $01 ; .......#
                        dc.b $1a ; 
                        dc.b $fe ; #######.
                        dc.b $1c ; 
                        dc.b $02 ; ......#.
                        dc.b $1d ; 
                        dc.b $7e ; .######.
                        dc.b $1f ; 
                        dc.b $02 ; ......#.
                        dc.b $20 ; 
                        dc.b $1c ; ...###..
                        dc.b $22 ; 
                        dc.b $04 ; .....#..
                        dc.b $23 ; 
                        dc.b $04 ; .....#..
                        dc.b $25 ; 
                        dc.b $0c ; ....##..
                        dc.b $28 ; 
                        dc.b $0c ; ....##..
                        dc.b $2b ; 
                        dc.b $18 ; ...##...
                        dc.b $2e ; 
                        dc.b $10 ; ...#....
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_67      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $10 ; 
                        dc.b $1f ; ...#####
                        dc.b $11 ; 
                        dc.b $e0 ; ###.....
                        dc.b $13 ; 
                        dc.b $1f ; ...#####
                        dc.b $14 ; 
                        dc.b $e0 ; ###.....
                        dc.b $16 ; 
                        dc.b $1f ; ...#####
                        dc.b $17 ; 
                        dc.b $e0 ; ###.....
                        dc.b $19 ; 
                        dc.b $1f ; ...#####
                        dc.b $1a ; 
                        dc.b $e0 ; ###.....
                        dc.b $1c ; 
                        dc.b $10 ; ...#....
                        dc.b $1f ; 
                        dc.b $10 ; ...#....
                        dc.b $22 ; 
                        dc.b $30 ; ..##....
                        dc.b $25 ; 
                        dc.b $30 ; ..##....
                        dc.b $28 ; 
                        dc.b $20 ; ..#.....
                        dc.b $2b ; 
                        dc.b $20 ; ..#.....
                        dc.b $2e ; 
                        dc.b $20 ; ..#.....
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_68      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0a ; 
                        dc.b $c0 ; ##......
                        dc.b $0c ; 
                        dc.b $03 ; ......##
                        dc.b $0d ; 
                        dc.b $e0 ; ###.....
                        dc.b $0f ; 
                        dc.b $0f ; ....####
                        dc.b $10 ; 
                        dc.b $f0 ; ####....
                        dc.b $12 ; 
                        dc.b $3f ; ..######
                        dc.b $13 ; 
                        dc.b $f0 ; ####....
                        dc.b $15 ; 
                        dc.b $1f ; ...#####
                        dc.b $16 ; 
                        dc.b $c0 ; ##......
                        dc.b $18 ; 
                        dc.b $0f ; ....####
                        dc.b $1b ; 
                        dc.b $04 ; .....#..
                        dc.b $1e ; 
                        dc.b $02 ; ......#.
                        dc.b $21 ; 
                        dc.b $01 ; .......#
                        dc.b $25 ; 
                        dc.b $c0 ; ##......
                        dc.b $28 ; 
                        dc.b $e0 ; ###.....
                        dc.b $2b ; 
                        dc.b $30 ; ..##....
                        dc.b $2e ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_69      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0a ; 
                        dc.b $08 ; ....#...
                        dc.b $0d ; 
                        dc.b $0e ; ....###.
                        dc.b $0e ; 
                        dc.b $40 ; .#......
                        dc.b $10 ; 
                        dc.b $df ; ##.#####
                        dc.b $11 ; 
                        dc.b $e0 ; ###.....
                        dc.b $12 ; 
                        dc.b $0d ; ....##.#
                        dc.b $13 ; 
                        dc.b $ff ; ########
                        dc.b $14 ; 
                        dc.b $f8 ; #####...
                        dc.b $15 ; 
                        dc.b $07 ; .....###
                        dc.b $16 ; 
                        dc.b $ff ; ########
                        dc.b $17 ; 
                        dc.b $fc ; ######..
                        dc.b $18 ; 
                        dc.b $27 ; ..#..###
                        dc.b $19 ; 
                        dc.b $ff ; ########
                        dc.b $1a ; 
                        dc.b $fe ; #######.
                        dc.b $1b ; 
                        dc.b $7f ; .#######
                        dc.b $1c ; 
                        dc.b $ff ; ########
                        dc.b $1d ; 
                        dc.b $fc ; ######..
                        dc.b $1e ; 
                        dc.b $7f ; .#######
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $ff ; ########
                        dc.b $21 ; 
                        dc.b $3f ; ..######
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $23 ; 
                        dc.b $fe ; #######.
                        dc.b $24 ; 
                        dc.b $7f ; .#######
                        dc.b $25 ; 
                        dc.b $ff ; ########
                        dc.b $26 ; 
                        
                        dc.b $ff ; <end of data>
                        
                        dc.b $ff ; ########
; -------------------------------------------------------------------------------------------------------------- ;
SpriteData_Map_01       dc.b $40 ; .#......
                        
                        dc.b $10 ; 
                        dc.b $00 ; ........
                        dc.b $13 ; 
                        dc.b $00 ; ........
                        dc.b $1b ; 
                        dc.b $07 ; .....###
                        dc.b $1c ; 
                        dc.b $00 ; ........
                        dc.b $1d ; 
                        dc.b $00 ; ........
                        dc.b $1e ; 
                        dc.b $07 ; .....###
                        dc.b $1f ; 
                        dc.b $00 ; ........
                        dc.b $20 ; 
                        dc.b $00 ; ........
                        dc.b $2e ; 
                        dc.b $00 ; ........
                        dc.b $31 ; 
                        dc.b $00 ; ........
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Map_02       dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $10 ; 
                        dc.b $1c ; ...###..
                        dc.b $13 ; 
                        dc.b $1c ; ...###..
                        dc.b $14 ; 
                        dc.b $00 ; ........
                        dc.b $15 ; 
                        dc.b $00 ; ........
                        dc.b $16 ; 
                        dc.b $00 ; ........
                        dc.b $1b ; 
                        dc.b $07 ; .....###
                        dc.b $1e ; 
                        dc.b $07 ; .....###
                        dc.b $26 ; 
                        dc.b $00 ; ........
                        dc.b $28 ; 
                        dc.b $00 ; ........
                        dc.b $29 ; 
                        dc.b $00 ; ........
                        dc.b $2a ; 
                        dc.b $00 ; ........
                        dc.b $2d ; 
                        dc.b $00 ; ........
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Map_03       dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $10 ; 
                        dc.b $1c ; ...###..
                        dc.b $13 ; 
                        dc.b $1c ; ...###..
                        dc.b $1b ; 
                        dc.b $07 ; .....###
                        dc.b $1d ; 
                        dc.b $00 ; ........
                        dc.b $1e ; 
                        dc.b $07 ; .....###
                        dc.b $20 ; 
                        dc.b $00 ; ........
                        dc.b $28 ; 
                        dc.b $1c ; ...###..
                        dc.b $2b ; 
                        dc.b $1c ; ...###..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Map_04       dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0c ; 
                        dc.b $00 ; ........
                        dc.b $0f ; 
                        dc.b $00 ; ........
                        dc.b $13 ; 
                        dc.b $1c ; ...###..
                        dc.b $10 ; 
                        dc.b $1c ; ...###..
                        dc.b $16 ; 
                        dc.b $00 ; ........
                        dc.b $1b ; 
                        dc.b $07 ; .....###
                        dc.b $1d ; 
                        dc.b $70 ; .###....
                        dc.b $1e ; 
                        dc.b $07 ; .....###
                        dc.b $20 ; 
                        dc.b $70 ; .###....
                        dc.b $27 ; 
                        dc.b $00 ; ........
                        dc.b $28 ; 
                        dc.b $1c ; ...###..
                        dc.b $2b ; 
                        dc.b $1c ; ...###..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Map_05       dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0a ; 
                        dc.b $1c ; ...###..
                        dc.b $0d ; 
                        dc.b $1c ; ...###..
                        dc.b $1b ; 
                        dc.b $03 ; ......##
                        dc.b $1c ; 
                        dc.b $80 ; #.......
                        dc.b $1d ; 
                        dc.b $e0 ; ###.....
                        dc.b $1e ; 
                        dc.b $03 ; ......##
                        dc.b $1f ; 
                        dc.b $80 ; #.......
                        dc.b $20 ; 
                        dc.b $e0 ; ###.....
                        dc.b $28 ; 
                        dc.b $1c ; ...###..
                        dc.b $2b ; 
                        dc.b $1c ; ...###..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Map_06       dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0e ; 
                        dc.b $70 ; .###....
                        dc.b $11 ; 
                        dc.b $70 ; .###....
                        dc.b $12 ; 
                        dc.b $01 ; .......#
                        dc.b $13 ; 
                        dc.b $c0 ; ##......
                        dc.b $15 ; 
                        dc.b $01 ; .......#
                        dc.b $16 ; 
                        dc.b $c0 ; ##......
                        dc.b $24 ; 
                        dc.b $01 ; .......#
                        dc.b $25 ; 
                        dc.b $c1 ; ##.....#
                        dc.b $26 ; 
                        dc.b $c0 ; ##......
                        dc.b $27 ; 
                        dc.b $01 ; .......#
                        dc.b $28 ; 
                        dc.b $c1 ; ##.....#
                        dc.b $29 ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Map_07       dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $10 ; 
                        dc.b $1c ; ...###..
                        dc.b $13 ; 
                        dc.b $1c ; ...###..
                        dc.b $1b ; 
                        dc.b $03 ; ......##
                        dc.b $1c ; 
                        dc.b $80 ; #.......
                        dc.b $1d ; 
                        dc.b $1c ; ...###..
                        dc.b $1e ; 
                        dc.b $03 ; ......##
                        dc.b $1f ; 
                        dc.b $80 ; #.......
                        dc.b $20 ; 
                        dc.b $1c ; ...###..
                        dc.b $28 ; 
                        dc.b $1c ; ...###..
                        dc.b $2b ; 
                        dc.b $1c ; ...###..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Map_08       dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $12 ; 
                        dc.b $01 ; .......#
                        dc.b $13 ; 
                        dc.b $c1 ; ##.....#
                        dc.b $14 ; 
                        dc.b $c0 ; ##......
                        dc.b $15 ; 
                        dc.b $01 ; .......#
                        dc.b $16 ; 
                        dc.b $c1 ; ##.....#
                        dc.b $17 ; 
                        dc.b $c0 ; ##......
                        dc.b $24 ; 
                        dc.b $01 ; .......#
                        dc.b $25 ; 
                        dc.b $c0 ; ##......
                        dc.b $27 ; 
                        dc.b $01 ; .......#
                        dc.b $28 ; 
                        dc.b $c0 ; ##......
                        dc.b $2c ; 
                        dc.b $70 ; .###....
                        dc.b $2f ; 
                        dc.b $70 ; .###....
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Map_09       dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $12 ; 
                        dc.b $01 ; .......#
                        dc.b $13 ; 
                        dc.b $c1 ; ##.....#
                        dc.b $14 ; 
                        dc.b $c0 ; ##......
                        dc.b $15 ; 
                        dc.b $01 ; .......#
                        dc.b $16 ; 
                        dc.b $c1 ; ##.....#
                        dc.b $17 ; 
                        dc.b $c0 ; ##......
                        dc.b $21 ; 
                        dc.b $07 ; .....###
                        dc.b $24 ; 
                        dc.b $07 ; .....###
                        dc.b $25 ; 
                        dc.b $01 ; .......#
                        dc.b $26 ; 
                        dc.b $c0 ; ##......
                        dc.b $28 ; 
                        dc.b $01 ; .......#
                        dc.b $29 ; 
                        dc.b $c0 ; ##......
                        dc.b $2b ; 
                        dc.b $70 ; .###....
                        dc.b $2e ; 
                        dc.b $70 ; .###....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SpriteData_Hill_70      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1c ; 
                        dc.b $18 ; ...##...
                        dc.b $1f ; 
                        dc.b $3c ; ..####..
                        dc.b $22 ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_71      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ; 
                        dc.b $3c ; ..####..
                        dc.b $1c ; 
                        dc.b $7e ; .######.
                        dc.b $1f ; 
                        dc.b $7e ; .######.
                        dc.b $22 ; 
                        dc.b $7e ; .######.
                        dc.b $25 ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_72      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $16 ; 
                        dc.b $3c ; ..####..
                        dc.b $19 ; 
                        dc.b $7e ; .######.
                        dc.b $1c ; 
                        dc.b $ff ; ########
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $25 ; 
                        dc.b $7e ; .######.
                        dc.b $28 ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_73      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $13 ; 
                        dc.b $7e ; .######.
                        dc.b $15 ; 
                        dc.b $01 ; .......#
                        dc.b $16 ; 
                        dc.b $ff ; ########
                        dc.b $17 ; 
                        dc.b $80 ; #.......
                        dc.b $18 ; 
                        dc.b $03 ; ......##
                        dc.b $19 ; 
                        dc.b $ff ; ########
                        dc.b $1a ; 
                        dc.b $c0 ; ##......
                        dc.b $1b ; 
                        dc.b $03 ; ......##
                        dc.b $1c ; 
                        dc.b $ff ; ########
                        dc.b $1d ; 
                        dc.b $c0 ; ##......
                        dc.b $1e ; 
                        dc.b $03 ; ......##
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $c0 ; ##......
                        dc.b $21 ; 
                        dc.b $03 ; ......##
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $23 ; 
                        dc.b $c0 ; ##......
                        dc.b $24 ; 
                        dc.b $03 ; ......##
                        dc.b $25 ; 
                        dc.b $ff ; ########
                        dc.b $26 ; 
                        dc.b $c0 ; ##......
                        dc.b $27 ; 
                        dc.b $01 ; .......#
                        dc.b $28 ; 
                        dc.b $ff ; ########
                        dc.b $29 ; 
                        dc.b $80 ; #.......
                        dc.b $2b ; 
                        dc.b $7e ; .######.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_74      dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $10 ; 
                        dc.b $7e ; .######.
                        dc.b $12 ; 
                        dc.b $01 ; .......#
                        dc.b $13 ; 
                        dc.b $ff ; ########
                        dc.b $14 ; 
                        dc.b $80 ; #.......
                        dc.b $15 ; 
                        dc.b $03 ; ......##
                        dc.b $16 ; 
                        dc.b $ff ; ########
                        dc.b $17 ; 
                        dc.b $c0 ; ##......
                        dc.b $18 ; 
                        dc.b $07 ; .....###
                        dc.b $19 ; 
                        dc.b $ff ; ########
                        dc.b $1a ; 
                        dc.b $e0 ; ###.....
                        dc.b $1b ; 
                        dc.b $07 ; .....###
                        dc.b $1c ; 
                        dc.b $ff ; ########
                        dc.b $1d ; 
                        dc.b $e0 ; ###.....
                        dc.b $1e ; 
                        dc.b $07 ; .....###
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $e0 ; ###.....
                        dc.b $21 ; 
                        dc.b $07 ; .....###
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $23 ; 
                        dc.b $e0 ; ###.....
                        dc.b $24 ; 
                        dc.b $07 ; .....###
                        dc.b $25 ; 
                        dc.b $ff ; ########
                        dc.b $26 ; 
                        dc.b $e0 ; ###.....
                        dc.b $27 ; 
                        dc.b $03 ; ......##
                        dc.b $28 ; 
                        dc.b $ff ; ########
                        dc.b $29 ; 
                        dc.b $c0 ; ##......
                        dc.b $2a ; 
                        dc.b $01 ; .......#
                        dc.b $2b ; 
                        dc.b $ff ; ########
                        dc.b $2c ; 
                        dc.b $80 ; #.......
                        dc.b $2e ; 
                        dc.b $7e ; .######.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Hill_75      dc.b $00 ; <flag: full sprite data>
                        
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $7e, $00 ; .........######.........
                        dc.b $01, $ff, $80 ; .......##########.......
                        dc.b $03, $ff, $c0 ; ......############......
                        dc.b $07, $ff, $e0 ; .....##############.....
                        dc.b $0f, $ff, $f0 ; ....################....
                        dc.b $0f, $ff, $f0 ; ....################....
                        dc.b $0f, $ff, $f0 ; ....################....
                        dc.b $0f, $ff, $f0 ; ....################....
                        dc.b $0f, $ff, $f0 ; ....################....
                        dc.b $07, $ff, $e0 ; .....##############.....
                        dc.b $03, $ff, $c0 ; ......############......
                        dc.b $01, $ff, $80 ; .......##########.......
                        dc.b $00, $7e, $00 ; .........######.........
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        
SpriteData_Hill_76      dc.b $00 ; <flag: full sprite data>

                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $ff, $00 ; ........########........
                        dc.b $03, $ff, $c0 ; ......############......
                        dc.b $07, $ff, $e0 ; .....##############.....
                        dc.b $0f, $ff, $f0 ; ....################....
                        dc.b $1f, $ff, $f8 ; ...##################...
                        dc.b $1f, $ff, $f8 ; ...##################...
                        dc.b $1f, $ff, $f8 ; ...##################...
                        dc.b $1f, $ff, $f8 ; ...##################...
                        dc.b $1f, $ff, $f8 ; ...##################...
                        dc.b $1f, $ff, $f8 ; ...##################...
                        dc.b $1f, $ff, $f8 ; ...##################...
                        dc.b $0f, $ff, $f0 ; ....################....
                        dc.b $07, $ff, $e0 ; .....##############.....
                        dc.b $03, $ff, $c0 ; ......############......
                        dc.b $00, $ff, $00 ; ........########........
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        
SpriteData_Hill_77      dc.b $00 ; <flag: full sprite data>
                        
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $ff, $00 ; ........########........
                        dc.b $03, $ff, $c0 ; ......############......
                        dc.b $07, $ff, $e0 ; .....##############.....
                        dc.b $0f, $ff, $f0 ; ....################....
                        dc.b $1f, $ff, $f8 ; ...##################...
                        dc.b $3f, $ff, $fc ; ..####################..
                        dc.b $3f, $ff, $fc ; ..####################..
                        dc.b $3f, $ff, $fc ; ..####################..
                        dc.b $3f, $ff, $fc ; ..####################..
                        dc.b $3f, $ff, $fc ; ..####################..
                        dc.b $3f, $ff, $fc ; ..####################..
                        dc.b $3f, $ff, $fc ; ..####################..
                        dc.b $1f, $ff, $f8 ; ...##################...
                        dc.b $0f, $ff, $f0 ; ....################....
                        dc.b $07, $ff, $e0 ; .....##############.....
                        dc.b $03, $ff, $c0 ; ......############......
                        dc.b $00, $ff, $00 ; ........########........
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        
SpriteData_Hill_fe      dc.b $00 ; <flag: full sprite data>
                        
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $ff, $00 ; ........########........
                        dc.b $03, $ff, $c0 ; ......############......
                        dc.b $07, $ff, $e0 ; .....##############.....
                        dc.b $0f, $ff, $f0 ; ....################....
                        dc.b $1f, $ff, $f8 ; ...##################...
                        dc.b $3f, $ff, $fc ; ..####################..
                        dc.b $7f, $ff, $fe ; .######################.
                        dc.b $7f, $ff, $fe ; .######################.
                        dc.b $7f, $ff, $fe ; .######################.
                        dc.b $7f, $ff, $fe ; .######################.
                        dc.b $7f, $ff, $fe ; .######################.
                        dc.b $7f, $ff, $fe ; .######################.
                        dc.b $7f, $ff, $fe ; .######################.
                        dc.b $3f, $ff, $fc ; ..####################..
                        dc.b $1f, $ff, $f8 ; ...##################...
                        dc.b $0f, $ff, $f0 ; ....################....
                        dc.b $07, $ff, $e0 ; .....##############.....
                        dc.b $03, $ff, $c0 ; ......############......
                        dc.b $00, $ff, $00 ; ........########........
                        dc.b $00, $00, $00 ; ........................

                        dc.b $00, $40, $1a ; .........#.........##.#.
                        dc.b $06, $1c, $7e ; .....##....###...######.
                        dc.b $1d, $0e, $1e ; ...###.#....###....####.
                        dc.b $3f, $1f, $ff ; ..######...#############
                        dc.b $20, $ff, $21 ; ..#.....########..#....#
                        dc.b $ff, $22, $ff ; ########..#...#.########
                        
SpriteData_Hill_78      dc.b $00 ; <flag: full sprite data>
                        
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $ff, $00 ; ........########........
                        dc.b $03, $ff, $c0 ; ......############......
                        dc.b $07, $ff, $e0 ; .....##############.....
                        dc.b $0f, $ff, $f0 ; ....################....
                        dc.b $1f, $ff, $f8 ; ...##################...
                        dc.b $3f, $ff, $fc ; ..####################..
                        dc.b $7f, $ff, $fe ; .######################.
                        dc.b $7f, $ff, $fe ; .######################.
                        dc.b $7f, $ff, $fe ; .######################.
                        dc.b $7f, $ff, $fe ; .######################.
                        dc.b $7f, $ff, $fe ; .######################.
                        dc.b $7f, $ff, $fe ; .######################.
                        dc.b $7f, $ff, $fe ; .######################.
                        dc.b $3f, $ff, $fc ; ..####################..
                        dc.b $1f, $ff, $f8 ; ...##################...
                        dc.b $0f, $ff, $f0 ; ....################....
                        dc.b $07, $ff, $e0 ; .....##############.....
                        dc.b $03, $ff, $c0 ; ......############......
                        dc.b $00, $ff, $00 ; ........########........
                        dc.b $00, $00, $00 ; ........................
; -------------------------------------------------------------------------------------------------------------- ;
                        dc.b $00 ; ........
; -------------------------------------------------------------------------------------------------------------- ;
SpriteData_Plane_76     dc.b $40 ; .#......
                        
                        dc.b $1a ; 
                        dc.b $06 ; .....##.
                        dc.b $1c ; 
                        dc.b $7e ; .######.
                        dc.b $1d ; 
                        dc.b $0e ; ....###.
                        dc.b $1e ; 
                        dc.b $3f ; ..######
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $ff ; ########
                        dc.b $21 ; 
                        dc.b $ff ; ########
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $23 ; 
                        dc.b $f0 ; ####....
                        dc.b $24 ; 
                        dc.b $3f ; ..######
                        dc.b $25 ; 
                        dc.b $fe ; #######.
                        
                        dc.b $ff ; <end of data>
                        
SpriteData_Plane_77     dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $18 ; 
                        dc.b $60 ; .##.....
                        dc.b $1b ; 
                        dc.b $70 ; .###....
                        dc.b $1c ; 
                        dc.b $7e ; .######.
                        dc.b $1e ; 
                        dc.b $ff ; ########
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $fc ; ######..
                        dc.b $21 ; 
                        dc.b $0f ; ....####
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $23 ; 
                        dc.b $ff ; ########
                        dc.b $25 ; 
                        dc.b $7f ; .#######
                        dc.b $26 ; 
                        dc.b $fc ; ######..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
A_5dc1                  dc.b $22 ; ..#...#.
                        dc.b $00 ; ........
                        dc.b $8f ; #...####
                        dc.b $5d ; .#.###.#
                        dc.b $20 ; ..#.....
                        dc.b $30 ; ..##....
                        dc.b $41 ; .#.....#
                        dc.b $b2 ; #.##..#.
                        dc.b $31 ; ..##...#
                        dc.b $3a ; ..###.#.
                        dc.b $81 ; #......#
                        dc.b $20 ; ..#.....
                        dc.b $49 ; .#..#..#
                        dc.b $b2 ; #.##..#.
                        dc.b $31 ; ..##...#
A_5dd0                  dc.b $20 ; ..#.....
                        dc.b $a4 ; #.#..#..
                        dc.b $20 ; ..#.....
                        dc.b $31 ; ..##...#
                        dc.b $36 ; ..##.##.
                        dc.b $3a ; ..###.#.
                        dc.b $43 ; .#....##
                        dc.b $31 ; ..##...#
                        dc.b $25 ; ..#..#.#
                        dc.b $28 ; ..#.#...
                        dc.b $49 ; .#..#..#
                        dc.b $29 ; ..#.#..#
                        dc.b $b2 ; #.##..#.
                        dc.b $30 ; ..##....
                        dc.b $3a ; ..###.#.
                        dc.b $82 ; #.....#.
A_5de0                  dc.b $00 ; ........
                        dc.b $9c ; #..###..
                        dc.b $5d ; .#.###.#
                        dc.b $2a ; ..#.#.#.
                        dc.b $30 ; ..##....
                        dc.b $4c ; .#..##..
                        dc.b $b2 ; #.##..#.
                        dc.b $32 ; ..##..#.
                        dc.b $30 ; ..##....
                        dc.b $3a ; ..###.#.
                        dc.b $43 ; .#....##
                        dc.b $b2 ; #.##..#.
                        dc.b $30 ; ..##....
                        dc.b $00 ; ........
                        dc.b $a6 ; #.#..##.
                        dc.b $5d ; .#.###.#
A_5df0                  dc.b $34 ; ..##.#..
                        dc.b $30 ; ..##....
                        dc.b $8d ; #...##.#
                        dc.b $20 ; ..#.....
                        dc.b $31 ; ..##...#
                        dc.b $30 ; ..##....
                        dc.b $30 ; ..##....
                        dc.b $00 ; ........
                        dc.b $b0 ; #.##....
                        dc.b $5d ; .#.###.#
                        dc.b $3e ; ..#####.
                        dc.b $30 ; ..##....
                        dc.b $99 ; #..##..#
                        dc.b $20 ; ..#.....
                        dc.b $53 ; .#.#..##
                        dc.b $50 ; .#.#....
A_5e00                  dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
; -------------------------------------------------------------------------------------------------------------- ;
